/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.watchers.logwatcher;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.postexecutor.PostExecutorTask;

public class Interpreter {
    private final Logger log = LogManager.getLogger(Interpreter.class);
    private String folderPath;
    private final Hashtable<String, Integer> logPatternLastMatchedTime;
    private final Timer timer;
    private final Map<String, ActionExecutor> actionExecutorMap;
    private final Map<String, String[]> regexMap;
    private final Map<String, Integer> regexPatternReloadTime;

    public Interpreter(Map<String, ActionExecutor> actionExecutorMap, Map<String, String[]> regexMap, Map<String, Integer> regexPatternReloadTime) {
        this.createLogFolder();
        this.actionExecutorMap = actionExecutorMap;
        this.regexMap = regexMap;
        this.logPatternLastMatchedTime = new Hashtable();
        this.regexPatternReloadTime = regexPatternReloadTime;
        this.timer = new Timer();
    }

    public void interpret(String errorLine, String completeLog) {
        this.diagnoseError(errorLine, completeLog);
    }

    private void diagnoseError(String errorLine, String completeLog) {
        this.createFolder();
        String regexPattern = this.findRegexPattern(errorLine);
        String[] executorsList = this.regexMap.get(regexPattern);
        if (executorsList != null && this.doAnalysis(executorsList, errorLine, regexPattern)) {
            try {
                this.timer.schedule((TimerTask)new PostExecutorTask(completeLog, this.folderPath), new Date(new Date().getTime() + 5000L));
            }
            catch (Exception e) {
                this.log.error("Error while scheduling the post executor task", (Throwable)e);
            }
        } else {
            this.deleteFolder();
        }
    }

    private String findRegexPattern(String errorLine) {
        for (Map.Entry<String, String[]> entry : this.regexMap.entrySet()) {
            String key = entry.getKey();
            if (!errorLine.matches(key)) continue;
            return key;
        }
        return null;
    }

    private boolean doAnalysis(String[] executorList, String logLine, String regexPattern) {
        long reloadTime = this.regexPatternReloadTime.get(regexPattern).intValue();
        if (this.checkRegexPatternReloadTime(logLine, regexPattern, reloadTime)) {
            this.log.info("Executing the action executors for the log line matching the regex pattern " + regexPattern);
            AtomicBoolean analysed = new AtomicBoolean(false);
            ExecutorService executorService = Executors.newFixedThreadPool(10);
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (String exec : executorList) {
                String executor = exec.trim();
                ActionExecutor actionExecutor = this.actionExecutorMap.get(executor);
                if (actionExecutor == null) {
                    this.log.error("Action executor " + executor + " is not available.");
                    continue;
                }
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    actionExecutor.execute(this.folderPath);
                    analysed.set(true);
                }, executorService);
                futures.add(future);
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            executorService.shutdown();
            return true;
        }
        return false;
    }

    private void createLogFolder() {
        this.folderPath = System.getProperty("app.home") + "/temp/";
        File logFolder = new File(this.folderPath);
        if (!logFolder.exists()) {
            logFolder.mkdir();
        }
    }

    private void deleteFolder() {
        File dumpFolder = new File(this.folderPath);
        if (dumpFolder.exists()) {
            String[] entries;
            for (String entry : entries = dumpFolder.list()) {
                File currentFile = new File(dumpFolder.getPath(), entry);
                currentFile.delete();
            }
            dumpFolder.delete();
        }
    }

    public void createFolder() {
        String folderName;
        File dumpFolder;
        this.folderPath = System.getProperty("app.home") + "/temp/";
        File logFolder = new File(this.folderPath);
        if (!logFolder.exists()) {
            logFolder.mkdir();
        }
        if (!(dumpFolder = new File(this.folderPath + (folderName = new Timestamp(System.currentTimeMillis()).toString().replace(" ", "_")))).exists()) {
            try {
                if (dumpFolder.mkdir()) {
                    this.folderPath = this.folderPath + folderName;
                }
            }
            catch (Exception e) {
                this.log.error("Error while creating folder for dump", (Throwable)e);
            }
        }
    }

    private int calculateTime(String timeStr) {
        String[] timeArray = timeStr.split(":");
        int hour = Integer.parseInt(timeArray[0]);
        int minute = Integer.parseInt(timeArray[1]);
        int second = Integer.parseInt(timeArray[0].substring(0, 2));
        return hour * 3600 + minute * 60 + second;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkRegexPatternReloadTime(String testLine, String regexPattern, long reloadTime) {
        String timeRegex = "\\d\\d:\\d\\d:\\d\\d,\\d\\d\\d";
        String[] errorLine = testLine.split("\n");
        Pattern pattern = Pattern.compile(timeRegex);
        Matcher matcher = pattern.matcher(errorLine[0]);
        if (!matcher.find()) return true;
        long errorTime = this.calculateTime(matcher.group(0));
        if (this.logPatternLastMatchedTime.containsKey(regexPattern)) {
            if (errorTime - (long)this.logPatternLastMatchedTime.get(regexPattern).intValue() <= reloadTime) return false;
            this.logPatternLastMatchedTime.replace(regexPattern, (int)errorTime);
            return true;
        } else {
            this.logPatternLastMatchedTime.put(regexPattern, (int)errorTime);
            return true;
        }
    }
}

