/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.watchers.trafficanalyzer;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ServerProcess;
import org.wso2.diagnostics.utils.CommonUtils;
import org.wso2.diagnostics.utils.ConfigMapHolder;
import org.wso2.diagnostics.watchers.trafficanalyzer.TrafficAnalyzer;

public class TrafficAnalyzerInitializer {
    private static final Logger log = LogManager.getLogger(TrafficAnalyzerInitializer.class);

    public static void init() {
        boolean isLastMinuteRequestsEnabled;
        boolean isLastFifteenSecondsRequestsEnabled;
        Map<String, Object> configMap = ConfigMapHolder.getInstance().getConfigMap();
        ScheduledExecutorService globalExecutorService = Executors.newSingleThreadScheduledExecutor();
        boolean isLastSecondRequestsEnabled = CommonUtils.getBooleanValue(configMap.get("traffic_analyzer.last_second_requests_enabled"), false);
        if (isLastSecondRequestsEnabled) {
            int lastSecondRequestsWindowSize = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_second_requests_window_size"), 300);
            int lastSecondRequestsInterval = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_second_requests_interval"), 1);
            int lastSecondRequestsDelay = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_second_requests_delay"), 60);
            TrafficAnalyzer lastSecondRequests = new TrafficAnalyzer(ServerProcess.getProcessId(), lastSecondRequestsWindowSize, lastSecondRequestsDelay, "LastSecondRequests");
            globalExecutorService.scheduleAtFixedRate(lastSecondRequests, 0L, lastSecondRequestsInterval, TimeUnit.SECONDS);
            log.info("LastSecondRequests Traffic Analyzer is enabled with window size: " + lastSecondRequestsWindowSize + ", interval: " + lastSecondRequestsInterval + ", delay: " + lastSecondRequestsDelay);
        }
        if (isLastFifteenSecondsRequestsEnabled = CommonUtils.getBooleanValue(configMap.get("traffic_analyzer.last_fifteen_seconds_requests_enabled"), false)) {
            int lastFifteenSecondsRequestsWindowSize = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_fifteen_seconds_requests_window_size"), 100);
            int lastFifteenSecondsRequestsInterval = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_fifteen_seconds_requests_interval"), 15);
            int lastFifteenSecondsRequestsDelay = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_fifteen_seconds_requests_delay"), 4);
            TrafficAnalyzer lastFifteenSecondsRequests = new TrafficAnalyzer(ServerProcess.getProcessId(), lastFifteenSecondsRequestsWindowSize, lastFifteenSecondsRequestsDelay, "Last15SecondRequests");
            globalExecutorService.scheduleAtFixedRate(lastFifteenSecondsRequests, 0L, lastFifteenSecondsRequestsInterval, TimeUnit.SECONDS);
            log.info("LastFifteenSecondsRequests Traffic Analyzer is enabled with window size: " + lastFifteenSecondsRequestsWindowSize + ", interval: " + lastFifteenSecondsRequestsInterval + ", delay: " + lastFifteenSecondsRequestsDelay);
        }
        if (isLastMinuteRequestsEnabled = CommonUtils.getBooleanValue(configMap.get("traffic_analyzer.last_minutes_requests_enabled"), false)) {
            int lastMinuteRequestsWindowSize = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_minutes_requests_window_size"), 100);
            int lastMinuteRequestsInterval = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_minutes_requests_interval"), 60);
            int lastMinuteRequestsDelay = CommonUtils.getIntegerValue(configMap.get("traffic_analyzer.last_minutes_requests_delay"), 1);
            TrafficAnalyzer lastMinuteRequests = new TrafficAnalyzer(ServerProcess.getProcessId(), lastMinuteRequestsWindowSize, lastMinuteRequestsDelay, "LastMinuteRequests");
            globalExecutorService.scheduleAtFixedRate(lastMinuteRequests, 0L, lastMinuteRequestsInterval, TimeUnit.SECONDS);
            log.info("LastMinuteRequests Traffic Analyzer is enabled with window size: " + lastMinuteRequestsWindowSize + ", interval: " + lastMinuteRequestsInterval + ", delay: " + lastMinuteRequestsDelay);
        }
    }
}

