<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:wsdl="http://www.w3.org/ns/wsdl" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:wrpc="http://www.w3.org/ns/wsdl/rpc" xmlns:wsoap="http://www.w3.org/ns/wsdl/soap" xmlns:whttp="http://www.w3.org/ns/wsdl/http"
    xmlns:wsdlx="http://www.w3.org/ns/wsdl-extensions" xmlns:wsaw="http://www.w3.org/2006/05/addressing/wsdl"
    exclude-result-prefixes="wsdl wrpc wsoap whttp wsdlx wsaw">
    <xsl:output method="xml" indent="yes"/>
    <!-- copy and paste from wsdl-xslt from here:***************** -->
    <xsl:variable name="root" select="/wsdl:description"/>
    <xsl:variable name="imported-wsdl"
        select="document($root[wsdl:include]/wsdl:include/@location)/wsdl:description |
        document($root[wsdl:import]/wsdl:import/@location)/wsdl:description"/>
    <!-- global (including imports/includes) collections of types that may be referred to later -->
    <xsl:variable name="all-interfaces" select="$root/wsdl:interface |
        $imported-wsdl/wsdl:interface"/>
    <xsl:variable name="all-operations" select="$all-interfaces/wsdl:operation"/>
    <xsl:variable name="all-faults" select="$all-interfaces/wsdl:fault"/>
    <xsl:variable name="all-bindings" select="$root/wsdl:binding | $imported-wsdl/wsdl:binding"/>
    <xsl:variable name="all-services" select="$root/wsdl:service| $imported-wsdl/wsdl:service"/>
    <!--
        Note - limited levels of Schema import/include functionality:
        Supported scenarios:
        - Embedded schemas (multiple schemas OK)
        - Schema directly pointed to by wsdl:types/xs:import/@schemaLocation.
        - Schema directly pointed to by wsdl:types/xs:schema/xs:import/@schemaLocation.
        - Above scenarios, when resulting from direct import/include of WSDL.
        - Chameleon includes (namespace specified on the include, not in the included schema.)
        Unsupported scenarios:
        - Schema imported or included indirectly (except as above).
        - Schema imported without @schemaLocation attribute (no catalog support).
    -->
    <xsl:variable name="imported-schema"
        select="document($root/wsdl:types[xs:import]/xs:import[@schemaLocation and
        not(starts-with(@schemaLocation,'#'))]/@schemaLocation)/xs:schema |
        document($root/wsdl:types/xs:schema[xs:import]/xs:import[@schemaLocation and
        not(starts-with(@schemaLocation,'#'))]/@schemaLocation)/xs:schema |
        document($imported-wsdl/wsdl:types[xs:import]/xs:import[@schemaLocation and
        not(starts-with(@schemaLocation,'#'))]/@schemaLocation)/xs:schema |
        $imported-wsdl/wsdl:types/xs:schema"/>
    <xsl:variable name="included-schema"
        select="document($root/wsdl:types/xs:schema[xs:include]/xs:include/@schemaLocation)/xs:schema"/>
    <!-- global (including imports/includes) collections of types that may be referred to later -->
    <xsl:variable name="all-elements" select="$root/wsdl:types/xs:schema/xs:element |
        $imported-wsdl/wsdl:types/xs:schema/xs:element | $imported-schema/xs:element |
        $included-schema/xs:element"/>
    <xsl:variable name="all-types" select="$root/wsdl:types/xs:schema/xs:simpleType |
        $imported-wsdl/wsdl:types/xs:schema/xs:simpleType | $imported-schema/xs:simpleType |
        $included-schema/xs:simpleType | $root/wsdl:types/xs:schema/xs:complexType |
        $imported-wsdl/wsdl:types/xs:schema/xs:complexType | $imported-schema/xs:complexType
        | $included-schema/xs:complexType"/>
    <!-- to here.***************** -->
    <xsl:template match="wsdl:description">
        <services>
            <xsl:for-each select="$all-services/wsdl:endpoint">
                <xsl:variable name="interface" select="substring-after(../@interface,':')"/>
                <service name="{ancestor::wsdl:service/@name}" endpoint="{@name}"
                    address="{@address}">
                    <xsl:variable name="binding" select="substring-after(@binding,':')"/>
                    <xsl:variable name="thisBinding" select="$all-bindings[@name = $binding]"/>
                    <xsl:for-each select="$thisBinding">
                            <!--<xsl:attribute name="binding"><xsl:value-of select="@name"/></xsl:attribute>-->
                        <xsl:choose>
                            <xsl:when test="@type='http://www.w3.org/ns/wsdl/soap' and
                                (not(@wsoap:version) or @wsoap:version='1.2')">
                                <xsl:attribute name="type">SOAP12</xsl:attribute>
                            </xsl:when>
                            <xsl:when test="@type='http://www.w3.org/ns/wsdl/http'">
                                <xsl:attribute name="type">HTTP</xsl:attribute>
                            </xsl:when>
                            <xsl:when test="@type='http://www.w3.org/ns/wsdl/soap' and
                                @wsoap:version='1.1'">
                                <xsl:attribute name="type">SOAP11</xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:comment>Unknown binding type: </xsl:comment>
                                <xsl:copy-of select="."/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                    <documentation>
                        <xsl:copy-of select="/wsdl:description/wsdl:documentation/node()"/>
                    </documentation>
                    <operations name="{$interface}">
                        <xsl:value-of select="@name"/>
                        <xsl:value-of select="$interface"/>
                        <xsl:for-each select="$all-interfaces[@name = $interface]">
                            <xsl:variable name="interfaces-extended-by-this-one">
                                <xsl:call-template name="interface-list">
                                    <xsl:with-param name="interface" select="."/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:for-each select="$all-operations[contains($interfaces-extended-by-this-one,
                                concat('[',ancestor::wsdl:interface/@name,']'))]">
                                <xsl:variable name="thisInterfaceOperation" select="."/>
                                <operation name="{@name}" pattern="{@pattern}" safe="{@wsdlx:safe = 'true' or @wsdlx:safe = '1'}">
                                    <documentation>
                                        <xsl:copy-of select="wsdl:documentation/node()"/>
                                    </documentation>
                                    <signature>
                                        <xsl:choose>
                                            <xsl:when test="@wrpc:signature">
                                                <xsl:attribute name="method">rpc-signature</xsl:attribute>
                                                <xsl:call-template name="rpc-signature">
                                                    <xsl:with-param name="signature" select="@wrpc:signature"/>
                                                    <xsl:with-param name="operation" select="."/>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:attribute name="method">inference</xsl:attribute>
                                                <xsl:call-template name="infer-params">
                                                    <xsl:with-param name="operation" select="."/>
                                                </xsl:call-template>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </signature>
                                    <xsl:for-each select="$thisBinding/wsdl:operation[substring-after(@ref, ':') = current()/@name]">
                                        <binding-details>
                                            <xsl:if test="../@type = 'http://www.w3.org/ns/wsdl/soap'">
                                                <xsl:if test="$thisInterfaceOperation/wsdl:input/@wsaw:Action">
                                                    <xsl:attribute name="wsawaction"><xsl:value-of select="$thisInterfaceOperation/wsdl:input/@wsaw:Action"/></xsl:attribute>
                                                </xsl:if>
                                                <xsl:if test="@wsoap:action">
                                                    <xsl:attribute name="soapaction"><xsl:value-of select="@wsoap:action"/></xsl:attribute>
                                                </xsl:if>
                                                <xsl:if test="../@wsoap:version='1.2' and ../@wsoap:protocol='http://www.w3.org/2003/05/soap/mep/soap-response/' and (@wsoap:mep='http://www.w3.org/2003/05/soap/mep/soap-response/' or (not(@wsoap:mep) and ../@wsoap:mepDefault='http://www.w3.org/2003/05/soap/mep/soap-response/'))">
                                                    <xsl:attribute name="httpmethod">GET</xsl:attribute>
                                                </xsl:if>
                                            </xsl:if>
                                            <xsl:if test="@whttp:location">
                                                <xsl:attribute name="httplocation"><xsl:value-of select="@whttp:location"/></xsl:attribute>
                                            </xsl:if>
                                            <xsl:if test="@whttp:ignoreUncited">
                                                <xsl:attribute name="httpignoreUncited"><xsl:value-of select="@whttp:ignoreUncited"/></xsl:attribute>
                                            </xsl:if>
                                            <xsl:choose>
                                                <xsl:when test="@whttp:queryParameterSeparator">
                                                    <xsl:attribute name="httpqueryParameterSeparator"><xsl:value-of select="@whttp:queryParameterSeparator"/></xsl:attribute>
                                                </xsl:when>
                                                <xsl:when test="../@whttp:queryParameterSeparatorDefault">
                                                    <xsl:attribute name="httpqueryParameterSeparator"><xsl:value-of select="../@whttp:queryParameterSeparatorDefault"/></xsl:attribute>
                                                </xsl:when>
                                            </xsl:choose> 
                                            <xsl:if test="../@type = 'http://www.w3.org/ns/wsdl/http'">
                                                <xsl:if test="@whttp:inputSerialization">
                                                    <xsl:attribute name="httpinputSerialization"><xsl:value-of select="@whttp:inputSerialization"/></xsl:attribute>
                                                </xsl:if>
                                                <xsl:choose>
                                                    <xsl:when test="@whttp:method">
                                                        <xsl:attribute name="httpmethod"><xsl:value-of select="@whttp:method"/></xsl:attribute>
                                                    </xsl:when>
                                                    <xsl:when test="../@whttp:methodDefault">
                                                        <xsl:attribute name="httpmethod"><xsl:value-of select="../@whttp:methodDefault"/></xsl:attribute>
                                                    </xsl:when>
                                                    <xsl:when test="$thisInterfaceOperation/@wsdlx:safe = 'true' or $thisInterfaceOperation/@wsdlx:safe = '1'">
                                                        <xsl:attribute name="httpmethod">GET</xsl:attribute>
                                                    </xsl:when>
                                                </xsl:choose> 
                                            </xsl:if>
                                        </binding-details>
                                    </xsl:for-each>
                                </operation>
                            </xsl:for-each>
                        </xsl:for-each>
                    </operations>
                </service>
            </xsl:for-each>
        </services>
    </xsl:template>
    <!-- A pair of recursive templates to list extended interfaces -->
    <xsl:template name="interface-list">
        <xsl:param name="interface"/>
        <xsl:text>[</xsl:text>
        <xsl:value-of select="$interface/@name"/>
        <xsl:text>]</xsl:text>
        <xsl:if test="$interface/@extends">
            <xsl:call-template name="extended-interface-list">
                <xsl:with-param name="interface-names" select="$interface/@extends"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="extended-interface-list">
        <xsl:param name="interface-names"/>
        <xsl:variable name="qnamesplit" select="concat(normalize-space($interface-names),' ')"/>
        <xsl:variable name="firstqname" select="substring-before($qnamesplit,' ')"/>
        <xsl:variable name="remainder" select="substring-after($qnamesplit,' ')"/>
        <xsl:variable name="interface-local-name">
            <xsl:choose>
                <xsl:when test="contains($firstqname, ':')">
                    <xsl:value-of select="substring-after($firstqname, ':')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$firstqname"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="interface-list">
            <xsl:with-param name="interface" select="$all-interfaces[@name=$interface-local-name]"/>
        </xsl:call-template>
        <xsl:if test="$remainder != ''">
            <xsl:call-template name="extended-interface-list">
                <xsl:with-param name="interface-names" select="$remainder"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <!-- Template to extract relevant details about the signature from the wrpc:signature extension. -->
    <xsl:template name="rpc-signature">
        <xsl:param name="signature"/>
        <xsl:param name="operation"/>
        <params>
            <xsl:if test="contains($operation/wsdl:input/@element, ':')">
                <xsl:attribute name="wrapper-element">
                    <xsl:value-of select="substring-after($operation/wsdl:input/@element,':')"/>
                </xsl:attribute>
                <xsl:attribute name="wrapper-element-ns">
                    <xsl:value-of select="$operation/wsdl:input/namespace::*[local-name() =
                        substring-before($operation/wsdl:input/@element,':')]"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="rpc-sig-params">
                <xsl:with-param name="signature" select="$signature"/>
                <xsl:with-param name="operation" select="$operation"/>
                <xsl:with-param name="process" select="'param'"/>
            </xsl:call-template>
            <xsl:variable name="this-element"
                select="$all-elements[@name=substring-after($operation/wsdl:input/@element,':')]"/>
            <xsl:variable name="this-type" select="$this-element[not(@type)]/xs:complexType |
                $all-types[@name=substring-after($this-element/@type,':')]"/>
            <xsl:for-each select="$this-type/xs:sequence/xs:any">
                <param token="#any">
                    <xsl:copy-of select="@minOccurs | @maxOccurs"/>
                    <xsl:if test="not(@minOccurs)"><xsl:attribute name="minOccurs">1</xsl:attribute></xsl:if>
                    <xsl:if test="not(@maxOccurs)"><xsl:attribute name="maxOccurs">1</xsl:attribute></xsl:if>
                </param>
            </xsl:for-each>
        </params>
        <returns>
            <xsl:if test="contains($operation/wsdl:output/@element, ':')">
                <xsl:attribute name="wrapper-element">
                    <xsl:value-of select="substring-after($operation/wsdl:output/@element,':')"/>
                </xsl:attribute>
                <xsl:attribute name="wrapper-element-ns">
                    <xsl:value-of select="$operation/wsdl:output/namespace::*[local-name() =
                        substring-before($operation/wsdl:output/@element,':')]"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="rpc-sig-params">
                <xsl:with-param name="signature" select="$signature"/>
                <xsl:with-param name="operation" select="$operation"/>
                <xsl:with-param name="process" select="'return'"/>
            </xsl:call-template>
        </returns>
    </xsl:template>
    <xsl:template name="rpc-sig-params">
        <xsl:param name="signature"/>
        <xsl:param name="operation"/>
        <xsl:param name="process"/>
        <xsl:if test="$signature != ''">
            <xsl:variable name="qname" select="substring-before($signature,' ')"/>
            <xsl:variable name="token" select="substring-before(substring-after(concat($signature,'
                '),' '),' ')"/>
            <xsl:choose>
                <xsl:when test="$token != '#return' and $process='param'">
                    <param name="{$qname}" token="{$token}">
                        <xsl:call-template name="param-type">
                            <xsl:with-param name="type" select="$qname"/>
                            <xsl:with-param name="message-reference" select="$operation/wsdl:input"
                            />
                        </xsl:call-template>
                    </param>
                </xsl:when>
                <xsl:when test="$token = '#return' and $process='return'">
                    <param name="{$qname}" token="{$token}">
                        <xsl:call-template name="param-type">
                            <xsl:with-param name="type" select="$qname"/>
                            <xsl:with-param name="message-reference" select="$operation/wsdl:output"
                            />
                        </xsl:call-template>
                    </param>
                </xsl:when>
            </xsl:choose>
            <xsl:call-template name="rpc-sig-params">
                <xsl:with-param name="signature"
                    select="substring-after(substring-after($signature,' '),' ')"/>
                <xsl:with-param name="operation" select="$operation"/>
                <xsl:with-param name="process" select="$process"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="param-type">
        <xsl:param name="type"/>
        <xsl:param name="message-reference"/>
        <xsl:variable name="this-element"
            select="$all-elements[@name=substring-after($message-reference/@element,':')]"/>
        <xsl:variable name="this-type" select="$this-element[not(@type)]/xs:complexType |
            $all-types[@name=substring-after($this-element/@type,':')]"/>
        <xsl:variable name="param-type" select="$this-type/xs:sequence/xs:element[@name=$type or
            @ref=$type]"/>
        <xsl:if test="$this-element/ancestor::xs:schema/@elementFormDefault != 'unqualified'">
            <xsl:attribute name="targetNamespace">
                <xsl:value-of select="$this-element/ancestor::xs:schema/@targetNamespace"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:attribute name="type">
            <xsl:value-of select="$param-type/@type"/>
        </xsl:attribute>
        <xsl:variable name="type-prefix" select="substring-before($param-type/@type,':')"/>
        <xsl:attribute name="type-namespace">
            <xsl:value-of select="$param-type/namespace::*[local-name() = $type-prefix]"/>
        </xsl:attribute>
        <xsl:copy-of select="@nillable | @minOccurs | @maxOccurs"/>
        <xsl:if test="not(@minOccurs)"><xsl:attribute name="minOccurs">1</xsl:attribute></xsl:if>
        <xsl:if test="not(@maxOccurs)"><xsl:attribute name="maxOccurs">1</xsl:attribute></xsl:if>
    </xsl:template>
    <!-- Template to extract relevant details about the signature from an rpc-style service, without the wrpc:signature extension. -->
    <xsl:template name="infer-params">
        <xsl:param name="operation"/>
        <xsl:variable name="input-element" select="$operation/wsdl:input/@element"/>
        <params>
            <xsl:choose>
                <xsl:when test="$input-element = '#none'"/>
                <xsl:when test="$input-element = '#any'">
                    <param name="payload" token="#in" type="anyType"
                        type-namespace="http://www.w3.org/2001/XMLSchema"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="this-element"
                        select="$all-elements[@name=substring-after($input-element,':')]"/>
                    <xsl:variable name="this-type" select="$this-element[not(@type)]/xs:complexType
                        | $all-types[@name=substring-after($this-element/@type,':')]"/>
                    <xsl:choose>
                        <xsl:when test="$this-type">
                            <xsl:if test="$this-type[not(xs:simpleContent or xs:complexContent or xs:group or xs:all or xs:choice or xs:attribute or xs:attributeGroup or xs:anyAttribute or xs:any[2])][not(xs:any/following-sibling::xs:*)]/xs:sequence[not(xs:element/@ref)]">
                                    <xsl:attribute name="wrapper-element">
                                    <xsl:call-template name="local-name">
                                        <xsl:with-param name="qname" select="$input-element"/>
                                    </xsl:call-template>
                                </xsl:attribute>
                                <xsl:attribute name="wrapper-element-ns">
                                    <xsl:value-of
                                        select="$operation/wsdl:input/namespace::*[local-name() =
                                        substring-before($input-element,':')]"/>
                                </xsl:attribute>
                            </xsl:if>
                            <xsl:for-each select="$this-type/xs:sequence/xs:element">
                                <param token="#in">
                                    <xsl:if test="$this-element/ancestor::xs:schema/@elementFormDefault != 'unqualified'">
                                        <xsl:attribute name="targetNamespace">
                                            <xsl:value-of select="$this-element/ancestor::xs:schema/@targetNamespace"/>
                                        </xsl:attribute>
                                    </xsl:if>
                                    <xsl:copy-of select="@nillable | @minOccurs | @maxOccurs"/>
                                    <xsl:if test="not(@minOccurs)"><xsl:attribute name="minOccurs">1</xsl:attribute></xsl:if>
                                    <xsl:if test="not(@maxOccurs)"><xsl:attribute name="maxOccurs">1</xsl:attribute></xsl:if>
                                    <xsl:attribute name="name">
                                        <xsl:call-template name="elementname-2-paramname">
                                            <xsl:with-param name="elementname" select="@name | @ref"/>
                                        </xsl:call-template>
                                    </xsl:attribute>
                                    <xsl:choose>
                                        <!-- Built-in schema type? -->
                                        <xsl:when test="namespace::*[local-name() =
                                            substring-before(current()/@type,':')] =
                                            'http://www.w3.org/2001/XMLSchema'">
                                            <xsl:attribute name="type"><xsl:value-of select="substring-after(@type,':')"/></xsl:attribute>
                                            <xsl:attribute name="type-namespace">http://www.w3.org/2001/XMLSchema</xsl:attribute>
                                            <xsl:attribute name="simple">
                                                <xsl:choose>
                                                    <xsl:when test="substring-after(@type,':') != 'anyType'">yes</xsl:when>
                                                    <xsl:otherwise>no</xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:attribute>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:attribute name="type"><xsl:value-of select="substring-after(@type,':')"/></xsl:attribute>
                                            <xsl:attribute name="type-namespace"><xsl:value-of select="namespace::*[local-name() =
                                                substring-before(current()/@type,':')]"/></xsl:attribute>
                                            <xsl:variable name="this-type-def" select="$all-types[@name=substring-after(current()/@type,':')]"/>
                                            <xsl:attribute name="simple">
                                                <xsl:choose>
                                                    <xsl:when test="local-name($this-type-def) = 'simpleType'">yes</xsl:when>
                                                    <xsl:otherwise>no</xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:attribute>
                                            <xsl:if test="$this-type-def/xs:restriction[substring-after(@base,':') = 'string']/xs:enumeration">
                                                <!--  potential bug: doesn't double-check the xs namespace on this -->
                                                <xsl:for-each select="$this-type-def/xs:restriction/xs:enumeration">
                                                    <enumeration value="{@value}"/>
                                                </xsl:for-each>
                                            </xsl:if>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </param>
                            </xsl:for-each>
                            <xsl:for-each select="$this-type/xs:sequence/xs:any">
                                <param token="#any">
                                    <xsl:copy-of select="@minOccurs | @maxOccurs"/>
                                    <xsl:if test="not(@minOccurs)"><xsl:attribute name="minOccurs">1</xsl:attribute></xsl:if>
                                    <xsl:if test="not(@maxOccurs)"><xsl:attribute name="maxOccurs">1</xsl:attribute></xsl:if>                                    
                                </param>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:when test="$this-element/namespace::*[local-name() = substring-before($this-element/@type,':')][. = 'http://www.w3.org/2001/XMLSchema'] and substring-after($this-element/@type,':') != 'anyType'">
                            <param name="{substring-after($input-element,':')}" token="#in"
                                type="{substring-after($this-element/@type,':')}" type-namespace="http://www.w3.org/2001/XMLSchema" simple="yes">
                                <xsl:if test="$this-element/ancestor::xs:schema/@elementFormDefault != 'unqualified'">
                                    <xsl:attribute name="targetNamespace">
                                        <xsl:value-of select="$this-element/ancestor::xs:schema/@targetNamespace"/>
                                    </xsl:attribute>
                                </xsl:if>
                            </param>                                
                        </xsl:when>
                        <xsl:otherwise>
                            <param name="{substring-after($input-element,':')}" token="#in"
                                type="anyType" type-namespace="http://www.w3.org/2001/XMLSchema" simple="no">
                                <xsl:if test="$this-element/ancestor::xs:schema/@elementFormDefault != 'unqualified'">
                                    <xsl:attribute name="targetNamespace">
                                        <xsl:value-of select="$this-element/ancestor::xs:schema/@targetNamespace"/>
                                    </xsl:attribute>
                                </xsl:if>
                            </param>                                
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </params>
        <xsl:variable name="output-element" select="$operation/wsdl:output/@element"/>
        <returns>
            <xsl:variable name="this-element" select="$all-elements[@name=$output-element or
                @name=substring-after($output-element,':')]"/>
            <xsl:variable name="this-type" select="$this-element[not(@type)]/xs:complexType |
                $all-types[@name=substring-after($this-element/@type,':')]"/>
            <xsl:choose>
                <xsl:when test="$output-element = '#none'"/>
                <xsl:when test="$output-element = '#any'">
                    <param token="#return" type="anyType"
                        type-namespace="http://www.w3.org/2001/XMLSchema" simple="no"/>
                </xsl:when>
                <xsl:when test="$this-type/xs:sequence">
                    <xsl:if test="$this-type[not(xs:simpleContent or xs:complexContent or xs:group or xs:all or xs:choice or xs:attribute or xs:attributeGroup or xs:anyAttribute or xs:any)]/xs:sequence[not(xs:element/@ref)]">
                        <xsl:attribute name="wrapper-element">
                            <xsl:call-template name="local-name">
                                <xsl:with-param name="qname" select="$output-element"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:attribute name="wrapper-element-ns">
                            <xsl:value-of select="$operation/wsdl:output/namespace::*[local-name() =
                                substring-before($output-element,':')]"/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:for-each select="$this-type/xs:sequence/xs:element">
                        <param token="#return" type="{substring-after(@type,':')}"
                            type-namespace="{namespace::*[local-name() =
                            substring-before(current()/@type,':')]}">
                            <xsl:if test="$this-element/ancestor::xs:schema/@elementFormDefault != 'unqualified'">
                                <xsl:attribute name="targetNamespace">
                                    <xsl:value-of select="$this-element/ancestor::xs:schema/@targetNamespace"/>
                                </xsl:attribute>
                            </xsl:if>
                            <xsl:copy-of select="@nillable | @minOccurs | @maxOccurs"/>
                            <xsl:if test="not(@minOccurs)"><xsl:attribute name="minOccurs">1</xsl:attribute></xsl:if>
                            <xsl:if test="not(@maxOccurs)"><xsl:attribute name="maxOccurs">1</xsl:attribute></xsl:if>
                            <xsl:attribute name="name">
                                <xsl:call-template name="elementname-2-paramname">
                                    <xsl:with-param name="elementname" select="@name | @ref"/>
                                </xsl:call-template>
                            </xsl:attribute>
                            <xsl:attribute name="simple">
                                <xsl:choose>
                                    <xsl:when test="namespace::*[local-name() =
                                        substring-before(current()/@type,':')] =
                                        'http://www.w3.org/2001/XMLSchema' and
                                        substring-after(@type,':') != 'anyType'">yes</xsl:when>
                                    <xsl:otherwise>no</xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                        </param>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="$this-element/namespace::*[local-name() = substring-before($this-element/@type,':')][. = 'http://www.w3.org/2001/XMLSchema'] and substring-after($this-element/@type,':') != 'anyType'">
                    <param name="{substring-after($output-element,':')}" token="#return"
                        type="{substring-after($this-element/@type,':')}" type-namespace="http://www.w3.org/2001/XMLSchema" simple="yes">
                        <xsl:if test="$this-element/ancestor::xs:schema/@elementFormDefault != 'unqualified'">
                            <xsl:attribute name="targetNamespace">
                                <xsl:value-of select="$this-element/ancestor::xs:schema/@targetNamespace"/>
                            </xsl:attribute>
                        </xsl:if>
                    </param>                        
                </xsl:when>
                <xsl:otherwise>
                    <param token="#any" type="anyType"
                        type-namespace="http://www.w3.org/2001/XMLSchema" simple="no">
                        <xsl:if test="$this-element/ancestor::xs:schema/@elementFormDefault != 'unqualified'">
                            <xsl:attribute name="targetNamespace">
                                <xsl:value-of select="$this-element/ancestor::xs:schema/@targetNamespace"/>
                            </xsl:attribute>
                        </xsl:if>
                    </param>                        
                </xsl:otherwise>
            </xsl:choose>
        </returns>
    </xsl:template>
    <xsl:template name="local-name">
        <xsl:param name="qname"/>
        <xsl:choose>
            <xsl:when test="contains($qname,':')">
                <xsl:value-of select="substring-after($qname,':')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$qname"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="elementname-2-paramname">
        <xsl:param name="elementname"/>
        <xsl:value-of select="translate($elementname,':.-','___')"/>
    </xsl:template>
</xsl:stylesheet>
