/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.io.File;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.esb.integration.common.extensions.carbonserver.TestServerManager;

public class CarbonServerExtension
extends ExecutionListenerExtension {
    private static TestServerManager serverManager;
    private static final Log log;
    private String executionEnvironment;

    public void initiate() {
        try {
            this.getParameters().putIfAbsent("-DportOffset", "0");
            serverManager = new TestServerManager(this.getAutomationContext(), null, this.getParameters()){

                @Override
                public void configureServer() {
                    if ("ESB".equalsIgnoreCase(System.getProperty("server.list"))) {
                        String carbonHome = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "server";
                        CarbonServerExtension.this.copyResources(carbonHome, this.getCarbonHome());
                        File dropinsDirectorySource = new File(carbonHome + File.separator + "dropins");
                        File dropinsDestination = new File(this.getCarbonHome() + File.separator + "dropins");
                        if (dropinsDirectorySource.exists() && dropinsDirectorySource.isDirectory()) {
                            try {
                                log.info((Object)("Copying " + dropinsDirectorySource.getPath() + " to " + dropinsDestination.getPath()));
                                FileUtils.copyDirectory((File)dropinsDirectorySource, (File)dropinsDestination);
                            }
                            catch (IOException e) {
                                log.error((Object)"Error while copying lib directory.", (Throwable)e);
                            }
                        }
                    } else if ("DSS".equalsIgnoreCase(System.getProperty("server.list"))) {
                        String carbonHome = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "DSS" + File.separator + "server";
                        CarbonServerExtension.this.copyResources(carbonHome, this.getCarbonHome());
                    }
                }
            };
            this.executionEnvironment = this.getAutomationContext().getConfigurationValue("//executionEnvironment/text()");
        }
        catch (XPathExpressionException e) {
            CarbonServerExtension.handleException("Error while initiating test environment", e);
        }
    }

    private void copyResources(String carbonHome, String destCarbonHome) {
        String repository = carbonHome + File.separator + "repository";
        File registrySource = new File(carbonHome + File.separator + "registry");
        File deploymentSource = new File(repository + File.separator + "deployment");
        File confSource = new File(carbonHome + File.separator + "conf");
        File libDirectorySource = new File(carbonHome + File.separator + "lib");
        File deploymentDestination = new File(destCarbonHome + File.separator + "repository" + File.separator + "deployment");
        File confDestination = new File(destCarbonHome + File.separator + "conf");
        File libDestination = new File(destCarbonHome + File.separator + "lib");
        File registryDestination = new File(destCarbonHome + File.separator + "registry");
        if (confSource.exists() && confSource.isDirectory()) {
            try {
                log.info((Object)("Copying " + confSource.getPath() + " to " + confDestination.getPath()));
                FileUtils.copyDirectory((File)confSource, (File)confDestination, (boolean)true);
            }
            catch (IOException e) {
                log.error((Object)"Error while copying conf directory.", (Throwable)e);
            }
        }
        if (deploymentSource.exists() && deploymentSource.isDirectory()) {
            try {
                log.info((Object)("Copying " + deploymentSource.getPath() + " to " + deploymentDestination.getPath()));
                FileUtils.copyDirectory((File)deploymentSource, (File)deploymentDestination);
            }
            catch (IOException e) {
                log.error((Object)"Error while copying deployment directory.", (Throwable)e);
            }
        }
        if (libDirectorySource.exists() && libDirectorySource.isDirectory()) {
            try {
                log.info((Object)("Copying " + libDirectorySource.getPath() + " to " + libDestination.getPath()));
                FileUtils.copyDirectory((File)libDirectorySource, (File)libDestination);
            }
            catch (IOException e) {
                log.error((Object)"Error while copying lib directory.", (Throwable)e);
            }
        }
        if (registrySource.exists() && registrySource.isDirectory()) {
            try {
                log.info((Object)("Copying " + registrySource.getPath() + " to " + registryDestination.getPath()));
                FileUtils.copyDirectory((File)registrySource, (File)registryDestination);
            }
            catch (IOException e) {
                log.error((Object)"Error while copying registry directory.", (Throwable)e);
            }
        }
    }

    public void onExecutionStart() {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                String carbonHome = serverManager.startServer();
                System.setProperty("carbon.home", carbonHome);
            }
        }
        catch (Exception e) {
            CarbonServerExtension.handleException("Fail to start carbon server ", e);
        }
    }

    public void onExecutionFinish() {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                serverManager.stopServer();
            }
        }
        catch (Exception e) {
            log.error((Object)"Fail to stop carbon server ", (Throwable)e);
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }

    public static void restartServer() {
        try {
            serverManager.restartServer();
        }
        catch (AutomationFrameworkException e) {
            throw new RuntimeException("Exception occurred while restarting the server", e);
        }
    }

    public static void shutdownServer() {
        try {
            serverManager.stopServer();
        }
        catch (AutomationFrameworkException e) {
            throw new RuntimeException("Exception occurred while shutdown the server", e);
        }
    }

    static {
        log = LogFactory.getLog(CarbonServerExtension.class);
    }
}

