/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.integration.common.utils.FileManager;
import org.wso2.esb.integration.common.extensions.carbonserver.CarbonServerManager;

public class TestServerManager {
    protected static CarbonServerManager carbonServer;
    protected String carbonZip;
    protected static int portOffset;
    protected static Map<String, String> commandMap;
    private static final Log log;
    protected static String carbonHome;
    protected String runtimePath;

    public TestServerManager(AutomationContext context) {
        carbonServer = new CarbonServerManager(context);
    }

    public TestServerManager(AutomationContext context, String carbonZip) {
        carbonServer = new CarbonServerManager(context);
        this.carbonZip = carbonZip;
    }

    public TestServerManager(AutomationContext context, int portOffset) {
        carbonServer = new CarbonServerManager(context);
        TestServerManager.portOffset = portOffset;
        commandMap.put("-DportOffset", String.valueOf(portOffset));
    }

    public TestServerManager(AutomationContext context, String carbonZip, Map<String, String> commandMap) {
        carbonServer = new CarbonServerManager(context);
        this.carbonZip = carbonZip;
        if (commandMap.get("-DportOffset") == null) {
            throw new IllegalArgumentException("portOffset value must be set in command list");
        }
        portOffset = Integer.parseInt(commandMap.get("-DportOffset"));
        TestServerManager.commandMap = commandMap;
    }

    public String getCarbonZip() {
        return this.carbonZip;
    }

    public String getCarbonHome() {
        return carbonHome;
    }

    public int getPortOffset() {
        return portOffset;
    }

    public String getRuntimePath() {
        return this.runtimePath;
    }

    public void configureServer() throws AutomationFrameworkException {
    }

    private void copyFileToServer(String sourcePath, String destinationPath) {
        log.info((Object)("Updating " + destinationPath + " for product EI"));
        String catalinaResourcePath = Paths.get(FrameworkPathUtil.getSystemResourceLocation(), sourcePath).toString();
        try {
            FileManager.copyFile((File)Paths.get(catalinaResourcePath, new String[0]).toFile(), (String)Paths.get(carbonHome, destinationPath).toString());
        }
        catch (IOException e) {
            log.warn((Object)("IOException while replacing " + destinationPath));
        }
    }

    public Map<String, String> getCommands() {
        return commandMap;
    }

    public String startServer() throws AutomationFrameworkException, IOException, XPathExpressionException {
        if (carbonHome == null) {
            if (this.carbonZip == null) {
                this.carbonZip = System.getProperty("carbon.zip");
            }
            if (this.carbonZip == null) {
                throw new IllegalArgumentException("carbon zip file cannot find in the given location");
            }
            carbonHome = carbonServer.setUpCarbonHome(this.carbonZip, commandMap.get("startupScript"));
            this.configureServer();
        }
        log.info((Object)("Carbon Home - " + carbonHome));
        portOffset = commandMap.get("-DportOffset") != null ? Integer.parseInt(commandMap.get("-DportOffset")) : 0;
        if (commandMap.get("runtimePath") != null) {
            this.runtimePath = commandMap.get("runtimePath");
        }
        carbonServer.startServerUsingCarbonHome(carbonHome, commandMap);
        return carbonHome;
    }

    public void restartGracefully() throws AutomationFrameworkException {
        if (carbonHome == null) {
            throw new AutomationFrameworkException("No Running Server found to restart. Please make sure whether server is started");
        }
        carbonServer.restartGracefully();
    }

    public void stopServer() throws AutomationFrameworkException {
        carbonServer.serverShutdown(portOffset, true);
    }

    public static void restartServer() throws AutomationFrameworkException {
        log.info((Object)"Preparing to restart the server ...");
        carbonServer.serverShutdown(portOffset, true);
        carbonServer.startServerUsingCarbonHome(carbonHome, commandMap);
        log.info((Object)"Server restarted successfully ...");
    }

    static {
        commandMap = new HashMap<String, String>();
        log = LogFactory.getLog(TestServerManager.class);
    }
}

