/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.CodeCoverageUtils;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.engine.frameworkutils.ReportGenerator;
import org.wso2.carbon.automation.engine.frameworkutils.TestFrameworkUtils;
import org.wso2.carbon.automation.extensions.servers.utils.ArchiveExtractor;
import org.wso2.carbon.automation.extensions.servers.utils.ClientConnectionUtil;
import org.wso2.carbon.automation.extensions.servers.utils.FileManipulator;
import org.wso2.carbon.automation.extensions.servers.utils.ServerLogReader;

public class CarbonServerManager {
    private static final Log log = LogFactory.getLog(CarbonServerManager.class);
    private Process process;
    private String carbonHome;
    private AutomationContext automationContext;
    private ServerLogReader inputStreamHandler;
    private ServerLogReader errorStreamHandler;
    private boolean isCoverageEnable = false;
    private String coverageDumpFilePath;
    private int portOffset = 0;
    private static final String SERVER_SHUTDOWN_MESSAGE = "Halting JVM";
    private static final long DEFAULT_START_STOP_WAIT_MS = 300000L;
    private static final String CMD_ARG = "cmdArg";
    private static int defaultHttpsPort = Integer.parseInt("9443");
    private String scriptName;
    private int managementPort;
    private int retryLimit = 3;
    private int retryAttempt = 0;

    public CarbonServerManager(AutomationContext context) {
        this.automationContext = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void startServerUsingCarbonHome(String carbonHome, Map<String, String> commandMap) throws AutomationFrameworkException {
        if (this.process != null) {
            log.warn((Object)"Tried to start a new server when there is one already running");
            return;
        }
        this.portOffset = this.getPortOffsetFromCommandMap(commandMap);
        try {
            if (!commandMap.isEmpty() && this.getPortOffsetFromCommandMap(commandMap) == 0) {
                System.setProperty("carbon.home", carbonHome);
            }
            File commandDir = new File(carbonHome);
            log.info((Object)"Starting server ... ");
            this.scriptName = commandMap.get("startupScript");
            String componentBinPath = commandMap.get("runtimePath");
            if (this.scriptName == null && componentBinPath == null) {
                this.scriptName = TestFrameworkUtils.getStartupScriptFileName((String)carbonHome);
            }
            String[] parameters = this.expandServerStartupCommandList(commandMap);
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                String[] cmdArray;
                if (componentBinPath != null) {
                    commandDir = new File(carbonHome + File.separator + componentBinPath);
                    cmdArray = new String[]{"cmd.exe", "/c", carbonHome + File.separator + componentBinPath + File.separator + this.scriptName + ".bat"};
                } else {
                    commandDir = new File(carbonHome + File.separator + "bin");
                    cmdArray = new String[]{"cmd.exe", "/c", commandDir + File.separator + this.scriptName + ".bat"};
                }
                cmdArray = this.mergePropertiesToCommandArray(parameters, cmdArray);
                this.process = Runtime.getRuntime().exec(cmdArray, null, commandDir);
            } else {
                String[] cmdArray;
                if (componentBinPath != null) {
                    commandDir = new File(carbonHome + File.separator + componentBinPath);
                    cmdArray = new String[]{"sh", carbonHome + File.separator + componentBinPath + File.separator + this.scriptName + ".sh"};
                } else {
                    commandDir = new File(carbonHome + File.separator + "bin");
                    cmdArray = new String[]{"sh", commandDir + File.separator + this.scriptName + ".sh"};
                }
                cmdArray = this.mergePropertiesToCommandArray(parameters, cmdArray);
                this.process = Runtime.getRuntime().exec(cmdArray, null, commandDir);
            }
            this.errorStreamHandler = new ServerLogReader("errorStream", this.process.getErrorStream());
            this.inputStreamHandler = new ServerLogReader("inputStream", this.process.getInputStream());
            this.inputStreamHandler.start();
            this.errorStreamHandler.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    this.serverShutdown(this.portOffset, false);
                }
                catch (Exception e) {
                    log.error((Object)"Error while server shutdown ..", (Throwable)e);
                }
            }));
            this.managementPort = 9154 + this.portOffset;
            this.waitTill(() -> !this.isRemotePortInUse("localhost", this.managementPort), 180, "startup");
            if (!this.isRemotePortInUse("localhost", this.managementPort)) {
                if (this.retryAttempt >= this.retryLimit) {
                    this.retryAttempt = 0;
                    throw new RuntimeException("Server initialization failed");
                }
                ++this.retryAttempt;
                log.info((Object)("Restarting server due to startup failure. Retry attempt: " + this.retryAttempt));
                this.serverShutdown(this.portOffset, true);
                this.startServerUsingCarbonHome(carbonHome, commandMap);
            } else {
                this.retryAttempt = 0;
            }
            log.info((Object)"Server started successfully ...");
            return;
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Unable to start server", e);
        }
    }

    private String[] mergePropertiesToCommandArray(String[] parameters, String[] cmdArray) {
        if (parameters != null) {
            cmdArray = this.mergerArrays(cmdArray, parameters);
        }
        return cmdArray;
    }

    public synchronized String setUpCarbonHome(String carbonServerZipFile, String startupScriptName) throws IOException, AutomationFrameworkException {
        String fileSeparator;
        if (this.process != null) {
            return this.carbonHome;
        }
        int indexOfZip = carbonServerZipFile.lastIndexOf(".zip");
        if (indexOfZip == -1) {
            throw new IllegalArgumentException(carbonServerZipFile + " is not a zip file");
        }
        String string = fileSeparator = File.separator.equals("\\") ? "\\" : "/";
        if (fileSeparator.equals("\\")) {
            carbonServerZipFile = carbonServerZipFile.replace("/", "\\");
        }
        String extractedCarbonDir = carbonServerZipFile.substring(carbonServerZipFile.lastIndexOf(fileSeparator) + 1, indexOfZip);
        FileManipulator.deleteDir((String)extractedCarbonDir);
        String extractDir = "carbontmp" + System.currentTimeMillis();
        String baseDir = System.getProperty("basedir", ".") + File.separator + "target";
        log.info((Object)"Extracting carbon zip file.. ");
        new ArchiveExtractor().extractFile(carbonServerZipFile, baseDir + File.separator + extractDir);
        this.carbonHome = new File(baseDir).getAbsolutePath() + File.separator + extractDir + File.separator + extractedCarbonDir;
        this.copyResources();
        try {
            this.isCoverageEnable = Boolean.parseBoolean(this.automationContext.getConfigurationValue("//coverage"));
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("Coverage configuration not found in automation.xml", (Throwable)e);
        }
        if (this.isCoverageEnable) {
            this.instrumentForCoverage(startupScriptName);
        }
        return this.carbonHome;
    }

    private void copyResources() throws IOException {
        String srcDirectory = System.getProperty("basedir", ".") + File.separator + "target" + File.separator + "samples" + File.separator;
        File srcFile = new File(srcDirectory);
        if (srcFile.exists()) {
            log.info((Object)("Copying resources from " + srcDirectory));
            FileUtils.copyDirectoryToDirectory((File)srcFile, (File)new File(this.carbonHome));
            log.info((Object)"Completed copying resources");
        }
    }

    public synchronized void serverShutdown(int portOffset, boolean skipRunningCodeCoverage) throws AutomationFrameworkException {
        if (this.process != null) {
            log.info((Object)"Shutting down server ...");
            try {
                int retryCount = 36;
                for (int i = 0; i < retryCount && this.isRemotePortInUse("localhost", this.managementPort); ++i) {
                    this.startProcess(this.carbonHome, this.getStartScriptCommand("stop"));
                    this.waitTill(() -> this.isRemotePortInUse("localhost", this.managementPort), 5, "shutdown");
                }
                if (this.isRemotePortInUse("localhost", this.managementPort)) {
                    throw new AutomationFrameworkException("Failed shutting down the sever");
                }
                log.info((Object)"Server stopped successfully ...");
            }
            catch (IOException | InterruptedException e) {
                throw new AutomationFrameworkException("Failed to stop server ", (Throwable)e);
            }
            this.inputStreamHandler.stop();
            this.errorStreamHandler.stop();
            this.process.destroy();
            this.process = null;
            if (!skipRunningCodeCoverage && this.isCoverageEnable) {
                try {
                    log.info((Object)"Generating Jacoco code coverage...");
                    this.generateCoverageReport(new File(this.carbonHome + File.separator + "wso2" + File.separator + "components" + File.separator + "plugins" + File.separator));
                }
                catch (IOException e) {
                    log.error((Object)"Failed to generate code coverage ", (Throwable)e);
                    throw new AutomationFrameworkException("Failed to generate code coverage ", (Throwable)e);
                }
            }
            if (portOffset == 0) {
                System.clearProperty("carbon.home");
            }
        } else {
            log.warn((Object)"Trying to shut down a server that hasn't completed startup. Hence aborting shutdown.");
        }
    }

    private Process startProcess(String workingDirectory, String[] cmdArray) throws IOException {
        File commandDir = new File(workingDirectory);
        ProcessBuilder processBuilder = new ProcessBuilder(cmdArray);
        processBuilder.directory(commandDir);
        return processBuilder.start();
    }

    private void waitTill(BooleanSupplier predicate, int maxWaitTime, String task) throws InterruptedException {
        long time = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxWaitTime);
        while (predicate.getAsBoolean() && System.currentTimeMillis() < time) {
            log.info((Object)("waiting for server " + task));
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    private boolean isRemotePortInUse(String hostName, int portNumber) {
        try {
            new Socket(hostName, portNumber).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String[] getStartScriptCommand(String ... commands) {
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        ArrayList<String> commandArray = operatingSystem.contains("windows") ? new ArrayList<String>(Arrays.asList("cmd.exe", "/c", this.carbonHome + File.separator + "bin" + File.separator + this.scriptName + ".bat")) : new ArrayList<String>(Arrays.asList("sh", this.carbonHome + File.separator + "bin" + File.separator + this.scriptName + ".sh"));
        commandArray.addAll(Arrays.asList(commands));
        return commandArray.toArray(new String[0]);
    }

    private void generateCoverageReport(File classesDir) throws IOException, AutomationFrameworkException {
        CodeCoverageUtils.executeMerge((String)FrameworkPathUtil.getJacocoCoverageHome(), (String)FrameworkPathUtil.getCoverageMergeFilePath());
        ReportGenerator reportGenerator = new ReportGenerator(new File(FrameworkPathUtil.getCoverageMergeFilePath()), classesDir, new File(CodeCoverageUtils.getJacocoReportDirectory()), null);
        reportGenerator.create();
        log.info((Object)("Jacoco coverage dump file path : " + FrameworkPathUtil.getCoverageDumpFilePath()));
        log.info((Object)("Jacoco class file path : " + classesDir));
        log.info((Object)("Jacoco coverage HTML report path : " + CodeCoverageUtils.getJacocoReportDirectory() + File.separator + "index.html"));
    }

    public synchronized void restartGracefully() throws AutomationFrameworkException {
        try {
            int httpsPort = defaultHttpsPort + this.portOffset;
            String backendURL = this.automationContext.getContextUrls().getSecureServiceUrl().replaceAll("(:\\d+)", ":" + httpsPort);
            User superUser = this.automationContext.getSuperTenant().getTenantAdmin();
            ClientConnectionUtil.sendGraceFullRestartRequest((String)backendURL, (String)superUser.getUserName(), (String)superUser.getPassword());
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("restart failed", (Throwable)e);
        }
        long time = System.currentTimeMillis() + 300000L;
        while (!this.inputStreamHandler.getOutput().contains(SERVER_SHUTDOWN_MESSAGE) && System.currentTimeMillis() < time) {
        }
        time = System.currentTimeMillis();
        while (System.currentTimeMillis() < time + 5000L) {
        }
        try {
            ClientConnectionUtil.waitForPort((int)Integer.parseInt((String)this.automationContext.getInstance().getPorts().get("https")), (String)((String)this.automationContext.getInstance().getHosts().get("default")));
            ClientConnectionUtil.waitForLogin((AutomationContext)this.automationContext);
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("Connection attempt to carbon server failed", (Throwable)e);
        }
    }

    private String[] expandServerStartupCommandList(Map<String, String> commandMap) {
        if (commandMap == null || commandMap.size() == 0) {
            return null;
        }
        Object[] cmdParaArray = null;
        String cmdArg = null;
        if (commandMap.containsKey(CMD_ARG)) {
            cmdArg = commandMap.get(CMD_ARG);
            cmdParaArray = cmdArg.trim().split("\\s+");
            commandMap.remove(CMD_ARG);
        }
        Object[] parameterArray = new String[commandMap.size()];
        int arrayIndex = 0;
        Set<Map.Entry<String, String>> entries = commandMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            String parameter = value == null || value.isEmpty() ? key : key + "=" + value;
            parameterArray[arrayIndex++] = parameter;
        }
        if (cmdArg != null) {
            commandMap.put(CMD_ARG, cmdArg);
        }
        if (cmdParaArray == null || cmdParaArray.length == 0) {
            return parameterArray;
        }
        return (String[])ArrayUtils.addAll((Object[])parameterArray, (Object[])cmdParaArray);
    }

    private int getPortOffsetFromCommandMap(Map<String, String> commandMap) {
        int portOffset = 0;
        if (commandMap.containsKey("-DportOffset")) {
            portOffset = Integer.parseInt(commandMap.get("-DportOffset"));
        }
        System.setProperty("port.offset", Integer.toString(portOffset));
        return portOffset;
    }

    private String[] mergerArrays(String[] array1, String[] array2) {
        return (String[])ArrayUtils.addAll((Object[])array1, (Object[])array2);
    }

    private void insertJacocoAgentToShellScript(String scriptName) throws IOException {
        String jacocoAgentFile = CodeCoverageUtils.getJacocoAgentJarLocation();
        this.coverageDumpFilePath = FrameworkPathUtil.getCoverageDumpFilePath();
        File inFile = Paths.get(this.carbonHome, "bin", scriptName + ".sh").toFile();
        File tmpFile = Paths.get(this.carbonHome, "tmp" + scriptName + ".sh").toFile();
        String lineToBeChecked = "-Dwso2.server.standalone=true";
        String lineToBeInserted = "-javaagent:" + jacocoAgentFile + "=destfile=" + this.coverageDumpFilePath + ",append=true,includes=" + CodeCoverageUtils.getInclusionJarsPattern((String)":") + ",excludes=" + CodeCoverageUtils.getExclusionJarsPattern((String)":") + " \\";
        CodeCoverageUtils.insertStringToFile((File)inFile, (File)tmpFile, (String)lineToBeChecked, (String)lineToBeInserted);
    }

    private void insertJacocoAgentToBatScript(String scriptName) throws IOException {
        String jacocoAgentFile = CodeCoverageUtils.getJacocoAgentJarLocation();
        this.coverageDumpFilePath = FrameworkPathUtil.getCoverageDumpFilePath();
        CodeCoverageUtils.insertJacocoAgentToStartupBat((File)Paths.get(this.carbonHome, "bin", scriptName + ".bat").toFile(), (File)Paths.get(this.carbonHome, "wso2", "tmp", scriptName + ".bat").toFile(), (String)"-Dcatalina.base", (String)("-javaagent:" + jacocoAgentFile + "=destfile=" + this.coverageDumpFilePath + ",append=true,includes=" + CodeCoverageUtils.getInclusionJarsPattern((String)":") + ",excludes=" + CodeCoverageUtils.getExclusionJarsPattern((String)":")));
    }

    private void instrumentForCoverage(String startupScriptName) throws IOException {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.insertJacocoAgentToBatScript(startupScriptName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Included files " + CodeCoverageUtils.getInclusionJarsPattern((String)":")));
                log.debug((Object)("Excluded files " + CodeCoverageUtils.getExclusionJarsPattern((String)":")));
            }
        } else {
            this.insertJacocoAgentToShellScript(startupScriptName);
        }
    }
}

