/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

class ServerUtils {
    private static final Log log = LogFactory.getLog(ServerUtils.class);

    private ServerUtils() {
    }

    static void copyResources(String product, String destCarbonHome, String clusterDepDir, String clusterRegDir) throws IOException {
        String carbonHome = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + product + File.separator + "server";
        ServerUtils.copyFolders(new File(carbonHome + File.separator + "conf"), new File(destCarbonHome + File.separator + "conf"));
        ServerUtils.copyFolders(new File(carbonHome + File.separator + "lib"), new File(destCarbonHome + File.separator + "lib"));
        File destinationDeploymentDirectory = new File(String.join((CharSequence)File.separator, destCarbonHome, "repository", "deployment"));
        if (clusterDepDir == null) {
            ServerUtils.copyFolders(new File(String.join((CharSequence)File.separator, carbonHome, "repository", "deployment")), destinationDeploymentDirectory);
        } else {
            ServerUtils.createSymlink(new File(clusterDepDir), destinationDeploymentDirectory);
        }
        File regDest = new File(destCarbonHome + File.separator + "registry");
        if (clusterRegDir == null) {
            ServerUtils.copyFolders(new File(carbonHome + File.separator + "registry"), regDest);
        } else {
            ServerUtils.createSymlink(new File(clusterRegDir), regDest);
        }
    }

    private static void copyFolders(File source, File destination) throws IOException {
        if (source.exists() && source.isDirectory()) {
            log.info((Object)("Copying " + source.getPath() + " to " + destination.getPath()));
            FileUtils.copyDirectory((File)source, (File)destination, (boolean)true);
        }
    }

    private static void createSymlink(File source, File destination) throws IOException {
        log.info((Object)("Creating sym link from : " + destination.toPath() + " to : " + source.toPath()));
        if (destination.exists() && !ServerUtils.deleteDirectory(destination)) {
            throw new IOException("Delete failed for : " + destination);
        }
        Files.createSymbolicLink(destination.toPath(), source.toPath(), new FileAttribute[0]);
    }

    private static boolean deleteDirectory(File directory) {
        File[] allContents = directory.listFiles();
        if (allContents != null) {
            Arrays.stream(allContents).forEach(ServerUtils::deleteDirectory);
        }
        return directory.delete();
    }
}

