/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.esb.integration.common.extensions.carbonserver.TestServerManager;

public class CarbonServerExtension
extends ExecutionListenerExtension {
    private TestServerManager serverManager;
    private static final Log log = LogFactory.getLog(CarbonServerExtension.class);
    private String executionEnvironment;

    public void initiate() {
        try {
            if (this.getParameters().get("-DportOffset") == null) {
                this.getParameters().put("-DportOffset", "0");
            }
            this.serverManager = new TestServerManager(this.getAutomationContext(), null, this.getParameters());
            this.executionEnvironment = this.getAutomationContext().getConfigurationValue("//executionEnvironment/text()");
        }
        catch (XPathExpressionException e) {
            CarbonServerExtension.handleException("Error while initiating test environment", e);
        }
    }

    public void onExecutionStart() {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                String carbonHome = this.serverManager.startServer();
                System.setProperty("carbon.home", carbonHome);
            }
        }
        catch (Exception e) {
            CarbonServerExtension.handleException("Fail to start carbon server ", e);
        }
    }

    public void onExecutionFinish() {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                this.serverManager.stopServer();
            }
        }
        catch (Exception e) {
            CarbonServerExtension.handleException("Fail to stop carbon server ", e);
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

