/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.wso2.ei.b7a.jms.BallerinaJmsException;

public class JmsBytesMessageUtils {
    public static ArrayValue readBytes(BytesMessage message) throws BallerinaJmsException {
        try {
            int bodyLength = (int)message.getBodyLength();
            byte[] bytes = new byte[bodyLength];
            message.readBytes(bytes);
            return new ArrayValue(bytes);
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while reading bytes message.", e);
        }
    }

    public static ArrayValue readPortionOfBytes(BytesMessage message, int length) throws BallerinaJmsException {
        try {
            long bodyLength = message.getBodyLength();
            if ((long)length > bodyLength) {
                throw new BallerinaJmsException("Length should be less than or equal to the message's body length.");
            }
            byte[] bytes = new byte[length];
            message.readBytes(bytes, length);
            return new ArrayValue(bytes);
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while reading portion of the bytes message.", e);
        }
    }

    public static void writeBytes(BytesMessage message, ArrayValue value) throws BallerinaJmsException {
        try {
            byte[] bytes = value.getBytes();
            message.writeBytes(bytes);
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while writing the bytes message.", e);
        }
    }

    public static void writePortionOfBytes(BytesMessage message, ArrayValue value, int offset, int length) throws BallerinaJmsException {
        try {
            byte[] bytes = value.getBytes();
            message.writeBytes(bytes, offset, length);
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while reading bytes.", e);
        }
    }
}

