/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.jms;

import java.util.ArrayList;
import java.util.Collections;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.wso2.ei.b7a.jms.BallerinaJmsException;

public class JmsMessageUtils {
    private JmsMessageUtils() {
    }

    public static boolean isTextMessage(Message message) {
        return message instanceof TextMessage;
    }

    public static boolean isMapMessage(Message message) {
        return message instanceof MapMessage;
    }

    public static boolean isBytesMessage(Message message) {
        return message instanceof BytesMessage;
    }

    public static boolean isStreamMessage(Message message) {
        return message instanceof StreamMessage;
    }

    public static ArrayValue getPropertyNames(Message message) throws BallerinaJmsException {
        try {
            ArrayList propertyNames = Collections.list(message.getPropertyNames());
            return new ArrayValue(propertyNames.toArray(), (BType)new BArrayType(BTypes.typeString));
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while getting property names.", e);
        }
    }

    public static void setJMSCorrelationIDAsBytes(Message message, ArrayValue value) throws BallerinaJmsException {
        try {
            byte[] correlationId = value.getBytes();
            message.setJMSCorrelationIDAsBytes(correlationId);
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while setting correlationId value as an array of bytes", e);
        }
    }
}

