/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ballerinalang.jvm.values.MapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.b7a.jms.BallerinaJmsException;
import org.wso2.ei.b7a.jms.Constants;
import org.wso2.ei.b7a.jms.JmsUtils;
import org.wso2.ei.b7a.jms.LoggingExceptionListener;

public class JmsConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnectionUtils.class);

    private JmsConnectionUtils() {
    }

    public static Connection createJmsConnection(String initialContextFactory, String providerUrl, String connectionFactoryName, MapValue<String, String> optionalConfigs) throws BallerinaJmsException {
        Connection connection = JmsConnectionUtils.createConnection(initialContextFactory, providerUrl, connectionFactoryName, optionalConfigs);
        try {
            if (connection.getClientID() == null) {
                connection.setClientID(UUID.randomUUID().toString());
            }
            connection.setExceptionListener((ExceptionListener)new LoggingExceptionListener());
            connection.start();
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while starting connection.", e);
        }
        return connection;
    }

    public static void startJmsConnection(Connection connection) throws BallerinaJmsException {
        try {
            connection.start();
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error starting connection", e);
        }
    }

    public static void stopJmsConnection(Connection connection) throws BallerinaJmsException {
        try {
            connection.stop();
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error stopping connection", e);
        }
    }

    private static Connection createConnection(String initialContextFactory, String providerUrl, String connectionFactoryName, MapValue<String, String> optionalConfigs) throws BallerinaJmsException {
        HashMap<String, String> configParams = new HashMap<String, String>();
        configParams.put("initialContextFactory", initialContextFactory);
        configParams.put("providerUrl", providerUrl);
        configParams.put("connectionFactoryName", connectionFactoryName);
        JmsConnectionUtils.preProcessIfWso2MB(configParams);
        JmsConnectionUtils.updateMappedParameters(configParams);
        Properties properties = new Properties();
        configParams.forEach(properties::put);
        optionalConfigs.forEach(properties::put);
        try {
            InitialContext initialContext = new InitialContext(properties);
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup(connectionFactoryName);
            String username = optionalConfigs.getStringValue("username");
            String password = optionalConfigs.getStringValue("password");
            if (JmsUtils.notNullOrEmptyAfterTrim(username) && password != null) {
                return connectionFactory.createConnection(username, password);
            }
            return connectionFactory.createConnection();
        }
        catch (JMSException | NamingException e) {
            String message = "Error while connecting to broker.";
            LOGGER.error(message, e);
            throw new BallerinaJmsException(message + " " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void preProcessIfWso2MB(Map<String, String> configParams) throws BallerinaJmsException {
        String initialConnectionFactoryName = configParams.get("initialContextFactory");
        if (!"bmbInitialContextFactory".equalsIgnoreCase(initialConnectionFactoryName) && !"wso2mbInitialContextFactory".equalsIgnoreCase(initialConnectionFactoryName)) return;
        configParams.put("initialContextFactory", "org.wso2.andes.jndi.PropertiesFileInitialContextFactory");
        String connectionFactoryName = configParams.get("connectionFactoryName");
        if (configParams.get("providerUrl") != null) {
            System.setProperty("qpid.dest_syntax", "BURL");
            if (!JmsUtils.notNullOrEmptyAfterTrim(connectionFactoryName)) throw new BallerinaJmsException("connectionFactoryName property should be set");
            configParams.put("connectionfactory." + connectionFactoryName, configParams.get("providerUrl"));
            configParams.remove("providerUrl");
            return;
        } else {
            if (configParams.get("configFilePath") == null) return;
            configParams.put("providerUrl", configParams.get("configFilePath"));
            configParams.remove("configFilePath");
        }
    }

    private static void updateMappedParameters(Map<String, String> configParams) {
        Iterator<Map.Entry<String, String>> iterator = configParams.entrySet().iterator();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String mappedParam = Constants.MAPPING_PARAMETERS.get(entry.getKey());
            if (mappedParam == null) continue;
            tempMap.put(mappedParam, entry.getValue());
            iterator.remove();
        }
        configParams.putAll(tempMap);
    }
}

