/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.wso2.ei.b7a.jms.BallerinaJmsException;

public class JmsMessageListenerUtils {
    private JmsMessageListenerUtils() {
    }

    public static void setMessageListener(MessageConsumer consumer, Object serviceObject) throws BallerinaJmsException {
        BRuntime runtime = BRuntime.getCurrentRuntime();
        try {
            ObjectValue service = (ObjectValue)serviceObject;
            consumer.setMessageListener((MessageListener)new ListenerImpl(service, runtime));
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error occurred while setting the message listener");
        }
    }

    private static class ListenerImpl
    implements MessageListener {
        private final ObjectValue serviceObject;
        private final BRuntime runtime;

        ListenerImpl(ObjectValue serviceObject, BRuntime runtime) {
            this.serviceObject = serviceObject;
            this.runtime = runtime;
        }

        public void onMessage(Message message) {
            String specificFunctionName;
            String messageObjectName;
            if (message instanceof TextMessage) {
                messageObjectName = "TextMessage";
                specificFunctionName = "onTextMessage";
            } else if (message instanceof MapMessage) {
                messageObjectName = "MapMessage";
                specificFunctionName = "onMapMessage";
            } else if (message instanceof BytesMessage) {
                messageObjectName = "BytesMessage";
                specificFunctionName = "onBytesMessage";
            } else if (message instanceof StreamMessage) {
                messageObjectName = "StreamMessage";
                specificFunctionName = "onStreamMessage";
            } else {
                messageObjectName = "Message";
                specificFunctionName = "onOtherMessage";
            }
            BPackage jmsPackage = new BPackage("wso2", "jms", "0.6.1");
            ObjectValue param = BallerinaValues.createObjectValue((BPackage)jmsPackage, (String)messageObjectName, (Object[])new Object[]{new HandleValue((Object)message)});
            Object[] params = new Object[]{param, true};
            AttachedFunction[] attachedFunctions = this.serviceObject.getType().getAttachedFunctions();
            if (this.isMessageTypeSpecificFunction(attachedFunctions)) {
                this.invokeMessageSpecificFunctions(specificFunctionName, attachedFunctions, params);
            } else {
                this.runtime.invokeMethodAsync(this.serviceObject, "onMessage", params);
            }
        }

        private boolean isMessageTypeSpecificFunction(AttachedFunction[] functions) {
            return functions.length > 1;
        }

        private void invokeMessageSpecificFunctions(String specificFunctionName, AttachedFunction[] attachedFunctions, Object[] params) {
            boolean functionFound = false;
            for (AttachedFunction function : attachedFunctions) {
                if (!specificFunctionName.equals(function.getName())) continue;
                functionFound = true;
                this.runtime.invokeMethodAsync(this.serviceObject, specificFunctionName, params);
                break;
            }
            if (!functionFound) {
                this.runtime.invokeMethodAsync(this.serviceObject, "onOtherMessage", params);
            }
        }
    }
}

