/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.b7a.jms.BallerinaJmsException;

public class JmsSessionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsSessionUtils.class);

    private JmsSessionUtils() {
    }

    public static Session createJmsSession(Connection connection, String ackModeString) throws BallerinaJmsException {
        int sessionAckMode;
        boolean transactedSession = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Session ack mode string: {}", (Object)ackModeString);
        }
        switch (ackModeString) {
            case "CLIENT_ACKNOWLEDGE": {
                sessionAckMode = 2;
                break;
            }
            case "SESSION_TRANSACTED": {
                sessionAckMode = 0;
                transactedSession = true;
                break;
            }
            case "DUPS_OK_ACKNOWLEDGE": {
                sessionAckMode = 3;
                break;
            }
            case "AUTO_ACKNOWLEDGE": {
                sessionAckMode = 1;
                break;
            }
            default: {
                throw new BallerinaJmsException("Unknown acknowledgment mode: " + ackModeString);
            }
        }
        try {
            return connection.createSession(transactedSession, sessionAckMode);
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error while creating session." + e.getMessage(), e);
        }
    }

    public static String createTemporaryJmsQueue(Session session) throws BallerinaJmsException {
        try {
            TemporaryQueue temporaryQueue = session.createTemporaryQueue();
            return temporaryQueue.getQueueName();
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error creating temporary queue.", e);
        }
    }

    public static String createTemporaryJmsTopic(Session session) throws BallerinaJmsException {
        try {
            TemporaryTopic temporaryTopic = session.createTemporaryTopic();
            return temporaryTopic.getTopicName();
        }
        catch (JMSException e) {
            throw new BallerinaJmsException("Error creating temporary topic.", e);
        }
    }
}

