/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.cli;

import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.cli.AbstractCliTest;
import org.wso2.micro.integrator.cli.util.TestUtils;

public class CliSequenceTestCase
extends AbstractCliTest {
    private static final String CLI_TEST_SEQUENCE = "CliTestSequence";
    private static final String CLI_SAMPLE_SEQUENCE = "CliSampleSequence";
    private static final String MAIN_SEQUENCE = "main";
    private static final String FAULT_SEQUENCE = "fault";

    @BeforeClass
    public void loginBeforeClass() throws IOException {
        super.login();
    }

    @Test
    public void miShowSequenceAllTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("sequence", "show");
        Assert.assertEquals((int)outputForCLICommand.size(), (int)5);
        String tableHeading = "NAME                STATS      TRACING";
        String testSequenceTableRow = "CliTestSequence     disabled   disabled";
        String sampleSequenceTableRow = "CliSampleSequence   disabled   disabled";
        String mainSequenceTableRow = "main                disabled   disabled";
        String faultSequenceTableRow = "fault               disabled   disabled";
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)tableHeading);
        Assert.assertTrue((boolean)outputForCLICommand.contains(testSequenceTableRow));
        Assert.assertTrue((boolean)outputForCLICommand.contains(sampleSequenceTableRow));
        Assert.assertTrue((boolean)outputForCLICommand.contains(mainSequenceTableRow));
        Assert.assertTrue((boolean)outputForCLICommand.contains(faultSequenceTableRow));
    }

    @Test
    public void miShowSequenceTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("sequence", "show", CLI_TEST_SEQUENCE);
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"Name - CliTestSequence");
    }

    @Test
    public void miShowSequenceNotFoundTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("sequence", "show", "UndefinedSequence");
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"[ERROR] Getting Information of the Sequence 404 Not Found");
    }

    @AfterClass
    public void logoutAfterClass() throws IOException {
        super.logout();
    }
}

