/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.cli.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class TestUtils {
    private TestUtils() {
    }

    public static String getMIBuildPath() throws IOException {
        File miBuildFilePath = new File("wso2mi-cli" + File.separator + "bin" + File.separator + "mi");
        return miBuildFilePath.getCanonicalPath();
    }

    public static List<String> getOutputForCLICommand(String artifactType, String command) throws IOException {
        String[] arguments = new String[]{TestUtils.getMIBuildPath(), artifactType, command};
        return TestUtils.runCommandWithArgs(arguments);
    }

    public static List<String> getOutputForCLICommandArtifactName(String artifactType, String command, String artifactName) throws IOException {
        String[] arguments = new String[]{TestUtils.getMIBuildPath(), artifactType, command, artifactName};
        return TestUtils.runCommandWithArgs(arguments);
    }

    public static List<String> runCommandWithArgs(String[] arguments) throws IOException {
        String line;
        Process process = TestUtils.runMiCommand(arguments);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line.trim());
        }
        return lines;
    }

    private static Process runMiCommand(String ... args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args);
        return builder.start();
    }

    public static ArrayList<String> getArtifactList(List<String> outputForCLICommand) {
        ArrayList<String> artifactName = new ArrayList<String>();
        artifactName.add(outputForCLICommand.get(1).replace(outputForCLICommand.get(1).split(" ")[0], "").trim());
        artifactName.add(outputForCLICommand.get(2).replace(outputForCLICommand.get(1).split(" ")[0], "").trim());
        return artifactName;
    }
}

