/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.cli;

import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.cli.AbstractCliTest;
import org.wso2.micro.integrator.cli.util.TestUtils;

public class CliCompositeappTestCase
extends AbstractCliTest {
    private static final String CLI_TEST_HELLO_CAR = "hello-worldCompositeApplication";
    private static final String CLI_TEST_MEDIATOR_CAR = "MediatorCApp";

    @BeforeClass
    public void loginBeforeClass() throws IOException {
        super.login();
    }

    @Test
    public void miShowCarbonappAllTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("compositeapp", "show");
        Assert.assertEquals((int)outputForCLICommand.size(), (int)3);
        String tableHeading = "NAME                              VERSION";
        String mediatorCarTableRow = "MediatorCApp                      1.0.0";
        String helloCarTableRow = "hello-worldCompositeApplication   1.0.0";
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"NAME                              VERSION");
        Assert.assertTrue((boolean)outputForCLICommand.contains("MediatorCApp                      1.0.0"));
        Assert.assertTrue((boolean)outputForCLICommand.contains("hello-worldCompositeApplication   1.0.0"));
    }

    @Test
    public void miShowCarbonappTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("compositeapp", "show", CLI_TEST_HELLO_CAR);
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"Name - hello-worldCompositeApplication");
    }

    @Test
    public void miShowCappNotFoundTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("compositeapp", "show", "UndefinedCapp");
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"[ERROR] Getting Information of the Carbon App 404 Not Found");
    }

    @AfterClass
    public void logoutAfterClass() throws IOException {
        super.logout();
    }
}

