/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.cli;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.cli.util.TestUtils;

public class CliRemoteTestCase {
    ProcessBuilder builder = null;
    private static final String CLI_TEST_REMOTE_SERVER = "TestServer";
    private static final String REMOTE_HOST = "192.168.1.15";
    private static final String GET_REMOTE_HOST_UPDATE = "192.168.1.17";
    private static final String REMOTE_PORT = "9164";

    @Test(priority=1)
    public void miAddRemoteServer() throws IOException, InterruptedException {
        this.builder = new ProcessBuilder(TestUtils.getMIBuildPath(), "remote", "add", CLI_TEST_REMOTE_SERVER, REMOTE_HOST, REMOTE_PORT);
        this.builder.start();
        TimeUnit.MILLISECONDS.sleep(3000L);
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("remote", "show");
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"remotes:");
        Assert.assertEquals((String)outputForCLICommand.get(1), (String)"TestServer:");
        Assert.assertEquals((String)outputForCLICommand.get(2), (String)"remote_address: 192.168.1.15");
        Assert.assertEquals((String)outputForCLICommand.get(3), (String)"remote_port: \"9164\"");
    }

    @Test(priority=2)
    public void miUpdateRemoteServer() throws IOException, InterruptedException {
        this.builder = new ProcessBuilder(TestUtils.getMIBuildPath(), "remote", "update", CLI_TEST_REMOTE_SERVER, GET_REMOTE_HOST_UPDATE, REMOTE_PORT);
        this.builder.start();
        TimeUnit.MILLISECONDS.sleep(3000L);
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("remote", "show");
        Assert.assertTrue((boolean)outputForCLICommand.stream().anyMatch(str -> str.trim().contains(GET_REMOTE_HOST_UPDATE)), (String)"Fail to Update host of the remote server of TestServer");
    }

    @Test(priority=4)
    public void miRemoveRemoteServer() throws IOException, InterruptedException {
        this.builder = new ProcessBuilder(TestUtils.getMIBuildPath(), "remote", "remove", CLI_TEST_REMOTE_SERVER);
        this.builder.start();
        TimeUnit.MILLISECONDS.sleep(3000L);
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("remote", "show");
        Assert.assertNotEquals((Object)outputForCLICommand.stream().anyMatch(str -> str.trim().contentEquals(CLI_TEST_REMOTE_SERVER)), (Object)"Fail to remove TestServer");
    }
}

