/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.cli;

import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.cli.AbstractCliTest;
import org.wso2.micro.integrator.cli.util.TestUtils;

public class CliEndpointTestCase
extends AbstractCliTest {
    private static final String CLI_SIMPLE_EP = "SimpleEP";
    private static final String CLI_STOCK_EP = "SimpleStockQuoteServiceEndpoint";

    @BeforeClass
    public void loginBeforeClass() throws IOException {
        super.login();
    }

    @Test
    public void miShowEndpointAllTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("endpoint", "show");
        Assert.assertEquals((int)outputForCLICommand.size(), (int)3);
        String TABLE_HEADING = "NAME                              TYPE      Active";
        String SIMPLE_EP_TABLE_ROW = "SimpleEP                          address   true";
        String STOCK_EP_TABLE_ROW = "SimpleStockQuoteServiceEndpoint   address   true";
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"NAME                              TYPE      Active");
        Assert.assertTrue((boolean)outputForCLICommand.contains("SimpleEP                          address   true"));
        Assert.assertTrue((boolean)outputForCLICommand.contains("SimpleStockQuoteServiceEndpoint   address   true"));
    }

    @Test
    public void miShowEndpointTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("endpoint", "show", CLI_SIMPLE_EP);
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"Name - SimpleEP");
    }

    @Test
    public void miShowEndpointNotFoundTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("endpoint", "show", "UndefinedEndpoint");
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"[ERROR] Getting Information of Endpoint 404 Not Found");
    }

    @AfterClass
    public void logoutAfterClass() throws IOException {
        super.logout();
    }
}

