/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.cli;

import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.cli.AbstractCliTest;
import org.wso2.micro.integrator.cli.util.TestUtils;

public class CliProxyServiceTestCase
extends AbstractCliTest {
    private static final String CLI_TEST_PROXY = "cliTestProxy";
    private static final String CLI_ADDRESS_PROXY = "cliAddressProxy";
    private static final String CLI_MEDIATOR_PROXY = "MediatorTestProxy";

    @BeforeClass
    public void loginBeforeClass() throws IOException {
        super.login();
    }

    @Test
    public void miShowProxyAllTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("proxyservice", "show");
        Assert.assertEquals((int)outputForCLICommand.size(), (int)4);
        String tableHeading = "NAME                WSDL 1.1                                                   WSDL 2.0";
        String testProxyTableRow = "MediatorTestProxy   http://localhost:8290/services/MediatorTestProxy?wsdl   http://localhost:8290/services/MediatorTestProxy?wsdl2";
        String mediatorProxyTableRow = "cliTestProxy        http://localhost:8290/services/cliTestProxy?wsdl        http://localhost:8290/services/cliTestProxy?wsdl2";
        String addressProxyTableRow = "cliAddressProxy     http://localhost:8290/services/cliAddressProxy?wsdl     http://localhost:8290/services/cliAddressProxy?wsdl2";
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)tableHeading);
        Assert.assertTrue((boolean)outputForCLICommand.contains(testProxyTableRow));
        Assert.assertTrue((boolean)outputForCLICommand.contains(mediatorProxyTableRow));
        Assert.assertTrue((boolean)outputForCLICommand.contains(addressProxyTableRow));
    }

    @Test
    public void miShowProxyTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("proxyservice", "show", CLI_TEST_PROXY);
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"Name - cliTestProxy");
    }

    @Test
    public void miShowProxyNotFoundTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("proxyservice", "show", "UndefinedProxy");
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"[ERROR] Getting Information of ProxyService 404 Not Found");
    }

    @AfterClass
    public void logoutAfterClass() throws IOException {
        super.logout();
    }
}

