/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.cli;

import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.cli.AbstractCliTest;
import org.wso2.micro.integrator.cli.util.TestUtils;

public class CliAPITestCase
extends AbstractCliTest {
    private static final String CLI_SAMPLE_API_1 = "cliSampleApi_1";
    private static final String CLI_SAMPLE_API_2 = "cliSampleApi_2";
    private static final String HELLO_WORLD_API = "HelloWorld";

    @BeforeClass
    public void loginBeforeClass() throws IOException {
        super.login();
    }

    @Test
    public void miShowAllApiTest() throws Exception {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommand("api", "show");
        Assert.assertEquals((int)outputForCLICommand.size(), (int)4);
        String tableHeading = "NAME             URL";
        String sampleApi1TableRow = "cliSampleApi_1   http://localhost:8290/cliSampleApi_1";
        String sampleApi2TableRow = "cliSampleApi_2   http://localhost:8290/cliSampleApi_2";
        String helloWorldApiTableRow = "HelloWorld       http://localhost:8290/hello-world";
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)tableHeading);
        Assert.assertTrue((boolean)outputForCLICommand.contains(sampleApi1TableRow));
        Assert.assertTrue((boolean)outputForCLICommand.contains(sampleApi2TableRow));
        Assert.assertTrue((boolean)outputForCLICommand.contains(helloWorldApiTableRow));
    }

    @Test
    public void miShowApiTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("api", "show", CLI_SAMPLE_API_1);
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"Name - cliSampleApi_1");
    }

    @Test
    public void miShowApiNotFoundTest() throws IOException {
        List<String> outputForCLICommand = TestUtils.getOutputForCLICommandArtifactName("api", "show", "UndefinedAPI");
        Assert.assertEquals((String)outputForCLICommand.get(0), (String)"[ERROR] Getting Information of the API 404 Not Found");
    }

    @AfterClass
    public void logoutAfterClass() throws IOException {
        super.logout();
    }
}

