/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.deployer.common;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.deployer.common.EventCallback;

public class DirectoryListner {
    private static Logger logger = LoggerFactory.getLogger(DirectoryListner.class);
    private WatchService watchService = FileSystems.getDefault().newWatchService();
    private Path targetDirectory;
    private WatchKey watchKey;
    private EventCallback eventCallback;

    public void registerTargetDir(Path targetDirPath, EventCallback callback) throws IOException {
        this.targetDirectory = targetDirPath;
        this.eventCallback = callback;
        this.watchKey = targetDirPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public void startListening() {
        while (true) {
            WatchKey key = null;
            try {
                key = this.watchService.take();
                this.eventCallback.exec(key);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Error occurred while waiting for directory change events", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

