/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mi.tooling.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Cipher;
import org.wso2.mi.tooling.security.EncryptionUtils;
import org.wso2.mi.tooling.security.exception.EncryptionToolException;
import org.wso2.mi.tooling.security.utils.IOUtils;

public class EncryptionManager {
    private Cipher cipher;
    private Properties properties;
    private Map<String, String> encryptedSecrets = new HashMap<String, String>();

    public EncryptionManager(Cipher cipher, Properties info) {
        this.cipher = cipher;
        this.properties = info;
    }

    public Map encrypt() {
        String inputType = this.properties.getProperty("secret.input.type").toLowerCase();
        if ("console".equals(inputType)) {
            String secret = this.properties.getProperty("secret.plaintext.secret");
            String alias = this.properties.getProperty("secret.plaintext.alias");
            this.encryptedSecrets.put(alias, EncryptionUtils.doEncryption(this.cipher, secret));
        } else if ("file".equals(inputType)) {
            this.doBulkEncryptionFromFile();
        } else {
            throw new EncryptionToolException("secret input type has not been set properly");
        }
        return this.encryptedSecrets;
    }

    private void doBulkEncryptionFromFile() {
        String file = this.properties.getProperty("secret.input.file");
        Properties secrets = IOUtils.getProperties(file);
        Set<String> aliases = secrets.stringPropertyNames();
        for (String alias : aliases) {
            this.encryptedSecrets.put(alias, EncryptionUtils.doEncryption(this.cipher, secrets.getProperty(alias)));
        }
    }
}

