/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mi.tooling.security;

import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import org.wso2.mi.tooling.security.EncryptionManager;
import org.wso2.mi.tooling.security.EncryptionUtils;
import org.wso2.mi.tooling.security.output.OutputManager;
import org.wso2.mi.tooling.security.utils.IOUtils;

public class EncryptionTool {
    public static void main(String[] args) {
        String keyStoreSource = System.getenv("keystore.source");
        if (keyStoreSource == null) {
            keyStoreSource = IOUtils.getDefaultLocation("keystore-info.properties");
            System.out.println("Using default keystore-info.properties location: " + keyStoreSource);
        }
        Cipher cipher = EncryptionUtils.initializeCipher(IOUtils.getProperties(keyStoreSource));
        String secretSource = System.getenv("secret.source");
        if (secretSource == null) {
            secretSource = IOUtils.getDefaultLocation("secret-info.properties");
            System.out.println("Using default secret-info.properties location: " + secretSource);
        }
        Properties encryptionInformation = IOUtils.getProperties(secretSource);
        EncryptionManager encryptionManager = new EncryptionManager(cipher, encryptionInformation);
        Map encodedValues = encryptionManager.encrypt();
        OutputManager outputManager = new OutputManager(encryptionInformation.getProperty("secret.output.type"), encodedValues);
        outputManager.setOutput();
        System.out.println("Encryption completed successfully... ");
    }
}

