/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mi.tooling.security;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;
import org.wso2.mi.tooling.security.exception.EncryptionToolException;

public class EncryptionUtils {
    public static Cipher initializeCipher(Properties properties) {
        Cipher cipher;
        String keyStoreFile = properties.getProperty("secret.keystore.location");
        String keyStoreType = properties.getProperty("secret.keystore.type");
        String keyAlias = properties.getProperty("secret.keystore.alias");
        String keyStorePassword = properties.getProperty("secret.keystore.password");
        keyStorePassword = new String(Base64.getDecoder().decode(keyStorePassword));
        KeyStore keyStore = EncryptionUtils.getKeyStore(keyStoreFile, keyStorePassword, keyStoreType);
        try {
            Certificate certs = keyStore.getCertificate(keyAlias);
            cipher = Cipher.getInstance(EncryptionUtils.getAlgorithm());
            cipher.init(1, certs);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionToolException("Error while initializing cipher ", e);
        }
        return cipher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore getKeyStore(String location, String storePassword, String storeType) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(location));){
            KeyStore keyStore = KeyStore.getInstance(storeType);
            keyStore.load(bufferedInputStream, storePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new EncryptionToolException("Error initializing Cipher", e);
        }
    }

    private static String getAlgorithm() {
        String algorithm = System.getenv("secret.encryption.algorithm");
        if (algorithm == null) {
            algorithm = "RSA/ECB/OAEPwithSHA1andMGF1Padding";
        }
        return algorithm;
    }

    public static String doEncryption(Cipher cipher, String plainTextPwd) {
        String encodedValue;
        try {
            byte[] encryptedPassword = cipher.doFinal(plainTextPwd.getBytes(Charset.forName("UTF-8")));
            encodedValue = DatatypeConverter.printBase64Binary((byte[])encryptedPassword);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionToolException("Error encrypting password ", e);
        }
        return encodedValue;
    }
}

