/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mi.tooling.security.output;

import java.util.Map;
import java.util.Properties;
import org.wso2.mi.tooling.security.exception.EncryptionToolException;
import org.wso2.mi.tooling.security.output.K8SecretYaml;
import org.wso2.mi.tooling.security.utils.IOUtils;

public class OutputManager {
    private String outputType;
    private Map<String, String> secrets;

    public OutputManager(String outputType, Map<String, String> encodedValues) {
        this.outputType = outputType;
        this.secrets = encodedValues;
    }

    public void setOutput() {
        if ("console".equalsIgnoreCase(this.outputType)) {
            this.doConsoleOutput();
        } else if ("file".equalsIgnoreCase(this.outputType)) {
            this.doFileOutput();
        } else if ("k8".equalsIgnoreCase(this.outputType)) {
            this.doK8Output();
        } else {
            throw new EncryptionToolException("Secret output type: " + this.outputType + " is not supported. Use console, file or k8.");
        }
    }

    private void doConsoleOutput() {
        this.secrets.forEach((alias, encodedValue) -> System.out.println(alias + " : " + encodedValue));
    }

    private void doFileOutput() {
        Properties properties = new Properties();
        properties.putAll(this.secrets);
        IOUtils.setProperties(IOUtils.getOutputFilePath("wso2mi-secrets.properties"), properties);
    }

    private void doK8Output() {
        K8SecretYaml k8SecretYaml = new K8SecretYaml();
        k8SecretYaml.setStringData(this.secrets);
        IOUtils.writeYamlFile(IOUtils.getOutputFilePath("wso2mikube-secrets.yaml"), k8SecretYaml);
    }
}

