/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mi.tooling.security.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import org.wso2.mi.tooling.security.exception.EncryptionToolException;
import org.wso2.mi.tooling.security.output.K8SecretYaml;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class IOUtils {
    public static Properties getProperties(String fileName) {
        Properties properties = new Properties();
        File propertiesFile = new File(fileName);
        if (!propertiesFile.exists()) {
            throw new EncryptionToolException(fileName + " file cannot be found");
        }
        try (FileInputStream in = new FileInputStream(propertiesFile);){
            properties.load(in);
        }
        catch (IOException error) {
            throw new EncryptionToolException("Error loading properties from file");
        }
        return properties;
    }

    public static void setProperties(String filePath, Properties properties) {
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            System.out.println("writing secrets to " + filePath);
            properties.store(outputStream, null);
        }
        catch (IOException error) {
            throw new EncryptionToolException("Error occurred while output file " + filePath);
        }
    }

    public static String getOutputFilePath(String fileName) {
        String workingDirectory = System.getProperty("user.dir");
        return Paths.get(workingDirectory, "security", fileName).toString();
    }

    public static void writeYamlFile(String filePath, K8SecretYaml yaml) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml output = new Yaml(options);
        try (FileWriter writer = new FileWriter(filePath);){
            output.dump(yaml, writer);
            System.out.println("Kubernetes secret file created in " + filePath + " with default name and namespace");
            System.out.println("You can change the default values as required before applying.");
        }
        catch (IOException e) {
            throw new EncryptionToolException("Error while creating " + filePath);
        }
    }

    public static String getDefaultLocation(String fileName) {
        String workingDirectory = System.getProperty("user.dir");
        return Paths.get(workingDirectory, fileName).toString();
    }
}

