/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.ftp.core.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.wso2.ei.b7a.ftp.core.client.FTPClientHelper;
import org.wso2.ei.b7a.ftp.core.client.FTPClientListener;
import org.wso2.ei.b7a.ftp.core.util.BallerinaFTPException;
import org.wso2.ei.b7a.ftp.core.util.FTPUtil;
import org.wso2.transport.remotefilesystem.client.connector.contract.FtpAction;
import org.wso2.transport.remotefilesystem.client.connector.contract.VFSClientConnector;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.impl.RemoteFileSystemConnectorFactoryImpl;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemMessage;

public class FTPClient {
    private FTPClient() {
    }

    public static void initClientEndpoint(ObjectValue clientEndpoint, MapValue<Object, Object> config) throws BallerinaFTPException {
        String protocol = config.getStringValue("protocol");
        if (FTPUtil.notValidProtocol(protocol)) {
            throw new BallerinaFTPException("Only FTP, SFTP and FTPS protocols are supported by FTP client.");
        }
        Map<String, String> authMap = FTPUtil.getAuthMap(config);
        clientEndpoint.addNativeData("username", (Object)authMap.get("username"));
        clientEndpoint.addNativeData("password", (Object)authMap.get("password"));
        clientEndpoint.addNativeData("host", (Object)config.getStringValue("host"));
        clientEndpoint.addNativeData("port", (Object)FTPUtil.extractPortValue(config.getIntValue("port")));
        clientEndpoint.addNativeData("protocol", (Object)protocol);
        HashMap<String, String> ftpConfig = new HashMap<String, String>(3);
        ftpConfig.put("PASSIVE_MODE", String.valueOf(true));
        ftpConfig.put("USER_DIR_IS_ROOT", String.valueOf(false));
        ftpConfig.put("AVOID_PERMISSION_CHECK", String.valueOf(true));
        clientEndpoint.addNativeData("map", ftpConfig);
    }

    public static ObjectValue get(ObjectValue clientConnector, String filePath) throws BallerinaFTPException {
        VFSClientConnector connector;
        String url = FTPUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeGetAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.GET);
        return null;
    }

    public static void append(ObjectValue clientConnector, MapValue<Object, Object> inputContent) throws BallerinaFTPException {
        try {
            RemoteFileSystemMessage message;
            String url = FTPUtil.createUrl(clientConnector, inputContent.getStringValue("filePath"));
            HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
            propertyMap.put("uri", url);
            boolean isFile = inputContent.getBooleanValue("isFile");
            if (isFile) {
                ObjectValue fileContent = inputContent.getObjectValue("fileContent");
                Channel byteChannel = (Channel)fileContent.getNativeData("byteChannel");
                message = new RemoteFileSystemMessage(byteChannel.getInputStream());
            } else {
                String textContent = inputContent.getStringValue("textContent");
                ByteArrayInputStream stream = new ByteArrayInputStream(textContent.getBytes());
                message = new RemoteFileSystemMessage((InputStream)stream);
            }
            CompletableFuture future = BRuntime.markAsync();
            FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeGenericAction(future));
            RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
            VFSClientConnector connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
            connector.send(message, FtpAction.APPEND);
            future.complete(null);
        }
        catch (IOException | RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
    }

    public static void put(ObjectValue clientConnector, MapValue<Object, Object> inputContent) throws BallerinaFTPException {
        try {
            RemoteFileSystemMessage message;
            String url = FTPUtil.createUrl(clientConnector, inputContent.getStringValue("filePath"));
            HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
            propertyMap.put("uri", url);
            boolean isFile = inputContent.getBooleanValue("isFile");
            if (isFile) {
                ObjectValue fileContent = inputContent.getObjectValue("fileContent");
                Channel byteChannel = (Channel)fileContent.getNativeData("byteChannel");
                message = new RemoteFileSystemMessage(byteChannel.getInputStream());
            } else {
                String textContent = inputContent.getStringValue("textContent");
                ByteArrayInputStream stream = new ByteArrayInputStream(textContent.getBytes());
                message = new RemoteFileSystemMessage((InputStream)stream);
            }
            CompletableFuture future = BRuntime.markAsync();
            FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeGenericAction(future));
            RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
            VFSClientConnector connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
            connector.send(message, FtpAction.PUT);
            future.complete(null);
        }
        catch (IOException | RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
    }

    public static void delete(ObjectValue clientConnector, String filePath) throws BallerinaFTPException {
        VFSClientConnector connector;
        String url = FTPUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.DELETE);
        future.complete(null);
    }

    public static boolean isDirectory(ObjectValue clientConnector, String filePath) throws BallerinaFTPException {
        VFSClientConnector connector;
        String url = FTPUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeIsDirectoryAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.ISDIR);
        return false;
    }

    public static ArrayValue list(ObjectValue clientConnector, String filePath) throws BallerinaFTPException {
        VFSClientConnector connector;
        String url = FTPUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeListAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.LIST);
        return null;
    }

    public static void mkdir(ObjectValue clientConnector, String path) throws BallerinaFTPException {
        VFSClientConnector connector;
        String url = FTPUtil.createUrl(clientConnector, path);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.MKDIR);
        future.complete(null);
    }

    public static void rename(ObjectValue clientConnector, String origin, String destination) throws BallerinaFTPException {
        VFSClientConnector connector;
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", FTPUtil.createUrl(clientConnector, origin));
        propertyMap.put("destination", FTPUtil.createUrl(clientConnector, destination));
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.RENAME);
        future.complete(null);
    }

    public static void rmdir(ObjectValue clientConnector, String filePath) throws BallerinaFTPException {
        VFSClientConnector connector;
        String url = FTPUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.RMDIR);
        future.complete(null);
    }

    public static int size(ObjectValue clientConnector, String filePath) throws BallerinaFTPException {
        VFSClientConnector connector;
        String url = FTPUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        propertyMap.put("PASSIVE_MODE", Boolean.TRUE.toString());
        CompletableFuture future = BRuntime.markAsync();
        FTPClientListener connectorListener = new FTPClientListener(future, remoteFileSystemBaseMessage -> FTPClientHelper.executeSizeAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
        connector.send(null, FtpAction.SIZE);
        return 0;
    }
}

