/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.ftp.core.server;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.wso2.ei.b7a.ftp.core.server.FTPListener;
import org.wso2.ei.b7a.ftp.core.util.BallerinaFTPException;
import org.wso2.ei.b7a.ftp.core.util.FTPUtil;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.impl.RemoteFileSystemConnectorFactoryImpl;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.server.connector.contract.RemoteFileSystemServerConnector;

public class FTPListenerHelper {
    private FTPListenerHelper() {
    }

    public static RemoteFileSystemServerConnector register(ObjectValue ftpListener, MapValue<Object, Object> serviceEndpointConfig, ObjectValue service, String name) throws BallerinaFTPException {
        try {
            Map<String, String> paramMap = FTPListenerHelper.getServerConnectorParamMap(serviceEndpointConfig);
            RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
            FTPListener listener = new FTPListener(BRuntime.getCurrentRuntime(), service);
            if (name == null || name.isEmpty()) {
                name = service.getType().getName();
            }
            RemoteFileSystemServerConnector serverConnector = fileSystemConnectorFactory.createServerConnector(name, paramMap, (RemoteFileSystemListener)listener);
            ftpListener.addNativeData("serverConnector", (Object)serverConnector);
            serviceEndpointConfig.addNativeData("serverConnector", (Object)serverConnector);
            return serverConnector;
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException("Unable to initialize the FTP listener: " + e.getMessage(), e);
        }
    }

    private static Map<String, String> getServerConnectorParamMap(MapValue serviceEndpointConfig) throws BallerinaFTPException {
        String privateKeyPath;
        MapValue privateKey;
        HashMap<String, String> params = new HashMap<String, String>(12);
        MapValue secureSocket = serviceEndpointConfig.getMapValue("secureSocket");
        String url = FTPUtil.createUrl(serviceEndpointConfig);
        params.put("uri", url);
        FTPListenerHelper.addStringProperty(serviceEndpointConfig, params);
        if (secureSocket != null && (privateKey = secureSocket.getMapValue("privateKey")) != null && (privateKeyPath = privateKey.getStringValue("path")) != null && !privateKeyPath.isEmpty()) {
            params.put("IDENTITY", privateKeyPath);
            String privateKeyPassword = privateKey.getStringValue("password");
            if (privateKeyPassword != null && !privateKeyPassword.isEmpty()) {
                params.put("IDENTITY_PASS_PHRASE", privateKeyPassword);
            }
        }
        params.put("USER_DIR_IS_ROOT", String.valueOf(false));
        params.put("AVOID_PERMISSION_CHECK", String.valueOf(true));
        params.put("PASSIVE_MODE", String.valueOf(true));
        return params;
    }

    private static void addStringProperty(MapValue config, Map<String, String> params) {
        String value = config.getStringValue("fileNamePattern");
        if (value != null && !value.isEmpty()) {
            params.put("fileNamePattern", value);
        }
    }

    public static void poll(MapValue<Object, Object> config) throws BallerinaFTPException {
        RemoteFileSystemServerConnector connector = (RemoteFileSystemServerConnector)config.getNativeData("serverConnector");
        try {
            connector.poll();
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaFTPException(e.getMessage());
        }
    }
}

