/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.ftp.core.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.b7a.ftp.core.util.BallerinaFTPException;

public class FTPUtil {
    private static final Logger log = LoggerFactory.getLogger(FTPUtil.class);
    private static final int MAX_PORT = 65535;

    private FTPUtil() {
    }

    public static boolean notValidProtocol(String url) {
        return !url.startsWith("ftp") && !url.startsWith("sftp") && !url.startsWith("ftps");
    }

    public static String createUrl(ObjectValue clientConnector, String filePath) throws BallerinaFTPException {
        String username = (String)clientConnector.getNativeData("username");
        String password = (String)clientConnector.getNativeData("password");
        String host = (String)clientConnector.getNativeData("host");
        int port = (Integer)clientConnector.getNativeData("port");
        String protocol = (String)clientConnector.getNativeData("protocol");
        return FTPUtil.createUrl(protocol, host, port, username, password, filePath);
    }

    public static String createUrl(MapValue config) throws BallerinaFTPException {
        MapValue basicAuth;
        String filePath = config.getStringValue("path");
        String protocol = config.getStringValue("protocol");
        String host = config.getStringValue("host");
        int port = FTPUtil.extractPortValue(config.getIntValue("port"));
        MapValue secureSocket = config.getMapValue("secureSocket");
        String username = null;
        String password = null;
        if (secureSocket != null && (basicAuth = secureSocket.getMapValue("basicAuth")) != null) {
            username = basicAuth.getStringValue("username");
            password = basicAuth.getStringValue("password");
        }
        return FTPUtil.createUrl(protocol, host, port, username, password, filePath);
    }

    private static String createUrl(String protocol, String host, int port, String username, String password, String filePath) throws BallerinaFTPException {
        String userInfo = username + ":" + password;
        URI uri = null;
        try {
            uri = new URI(protocol, userInfo, host, port, filePath, null, null);
        }
        catch (URISyntaxException e) {
            throw new BallerinaFTPException("Error occurred while constructing a URI from host: " + host + ", port: " + port + ", username: " + username + " and basePath: " + filePath + e.getMessage(), e);
        }
        return uri.toString();
    }

    public static Map<String, String> getAuthMap(MapValue config) {
        MapValue basicAuth;
        MapValue secureSocket = config.getMapValue("secureSocket");
        String username = null;
        String password = null;
        if (secureSocket != null && (basicAuth = secureSocket.getMapValue("basicAuth")) != null) {
            username = basicAuth.getStringValue("username");
            password = basicAuth.getStringValue("password");
        }
        HashMap<String, String> authMap = new HashMap<String, String>();
        authMap.put("username", username);
        authMap.put("password", password);
        return authMap;
    }

    public static ErrorValue createError(String error, String details) {
        return BallerinaErrors.createError((String)error, (String)details);
    }

    public static int extractPortValue(long longValue) {
        if (longValue <= 0L || longValue > 65535L) {
            log.error("Invalid port number given in configuration");
            return -1;
        }
        try {
            return Math.toIntExact(longValue);
        }
        catch (ArithmeticException e) {
            log.warn("The value set for port needs to be less than {}. The port value is set to {}", (Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
    }

    public static BType getFileInfoType() {
        MapValue fileInfoStruct = BallerinaValues.createRecordValue((BPackage)new BPackage("wso2", "ftp", "0.3.1"), (String)"FileInfo");
        return fileInfoStruct.getType();
    }
}

