/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.ftp.testutil;

import java.util.concurrent.TimeUnit;
import org.ballerinalang.jvm.values.MapValue;
import org.mockftpserver.fake.FakeFtpServer;
import org.mockftpserver.fake.UserAccount;
import org.mockftpserver.fake.filesystem.DirectoryEntry;
import org.mockftpserver.fake.filesystem.FileEntry;
import org.mockftpserver.fake.filesystem.FileSystem;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.UnixFakeFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.b7a.ftp.core.util.BallerinaFTPException;
import org.wso2.ei.b7a.ftp.core.util.FTPUtil;

public class MockFTPServer {
    private static final Logger logger = LoggerFactory.getLogger((String)"ballerina");
    private static FakeFtpServer ftpServer;

    MockFTPServer() {
    }

    public static void initServer(MapValue<Object, Object> config) throws BallerinaFTPException {
        MapValue basicAuth;
        int port = FTPUtil.extractPortValue(config.getIntValue("port"));
        MapValue secureSocket = config.getMapValue("secureSocket");
        String username = null;
        String password = null;
        if (secureSocket != null && (basicAuth = secureSocket.getMapValue("basicAuth")) != null) {
            username = basicAuth.getStringValue("username");
            password = basicAuth.getStringValue("password");
        }
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            throw new BallerinaFTPException("Username and password cannot be empty");
        }
        ftpServer = new FakeFtpServer();
        ftpServer.setServerControlPort(port);
        String rootFolder = "/home/in";
        String content = "File content";
        ftpServer.addUserAccount(new UserAccount(username, password, rootFolder));
        UnixFakeFileSystem fileSystem = new UnixFakeFileSystem();
        fileSystem.add((FileSystemEntry)new DirectoryEntry(rootFolder));
        fileSystem.add((FileSystemEntry)new FileEntry("/home/in/test1.txt", content));
        fileSystem.add((FileSystemEntry)new FileEntry("/home/in/test2.txt", content));
        fileSystem.add((FileSystemEntry)new FileEntry("/home/in/test3.txt", content));
        fileSystem.add((FileSystemEntry)new DirectoryEntry("/home/in/folder1"));
        fileSystem.add((FileSystemEntry)new DirectoryEntry("/home/in/folder1/subfolder1"));
        fileSystem.add((FileSystemEntry)new DirectoryEntry("/home/in/childDirectory"));
        fileSystem.add((FileSystemEntry)new FileEntry("/home/in/child_directory/content1.txt"));
        fileSystem.add((FileSystemEntry)new FileEntry("/home/in/child_directory/content2.txt"));
        ftpServer.setFileSystem((FileSystem)fileSystem);
        ftpServer.start();
        logger.info("Starting FTP server...");
        for (int i = 0; !ftpServer.isStarted() && i < 10; ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BallerinaFTPException("Error in starting mock FTP server");
            }
        }
        logger.info("Started Mock FTP server");
    }

    public static void stopServer() {
        if (ftpServer.isStarted()) {
            ftpServer.stop();
        }
        logger.info("Stopped Mock FTP server");
    }
}

