/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.lang.StringUtils;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.esb.integration.common.utils.CarbonLogTailer;

public class CarbonLogReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CarbonLogReader.class);
    private CarbonLogTailer carbonLogTailer;
    private Tailer tailer;
    private File carbonLogFile;
    private boolean startReadingFromEndOfFile = true;

    public CarbonLogReader() {
        this.init(true);
    }

    public CarbonLogReader(boolean startReadingFromEndOfFile) {
        this.init(startReadingFromEndOfFile);
    }

    private void init(boolean startReadingFromEndOfFile) {
        this.carbonLogTailer = new CarbonLogTailer();
        this.carbonLogFile = new File(System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "logs" + File.separator + "wso2carbon.log");
        this.startReadingFromEndOfFile = startReadingFromEndOfFile;
    }

    public void start() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting to tail carbon logs from : " + this.carbonLogFile.getPath());
        }
        this.tailer = new Tailer(this.carbonLogFile, (TailerListener)this.carbonLogTailer, 1L, this.startReadingFromEndOfFile);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.setDaemon(true);
        thread.start();
        Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.SECONDS).until(this.hasThreadStarted(thread));
    }

    public String getLogs() {
        return this.carbonLogTailer.getCarbonLogs();
    }

    public void clearLogs() {
        this.carbonLogTailer.clearLogs();
    }

    public void stop() {
        LOGGER.debug("Stopped tailing carbon logs.");
        this.tailer.stop();
    }

    public boolean assertIfLogExists(String expected) {
        return this.getLogs().contains(expected);
    }

    public boolean assertIfLogExists(String expected, int numberofOccurrences) {
        return numberofOccurrences == StringUtils.countMatches((String)this.getLogs(), (String)expected);
    }

    public String getSubstringBetweenStrings(String startWith, String endWith, int timeout) throws InterruptedException {
        for (int i = 0; i < timeout; ++i) {
            TimeUnit.SECONDS.sleep(1L);
            if (!this.assertIfLogExists(startWith) || !this.assertIfLogExists(endWith) || StringUtils.substringBetween((String)this.getLogs(), (String)startWith, (String)endWith).isEmpty()) continue;
            return StringUtils.substringBetween((String)this.getLogs(), (String)startWith, (String)endWith);
        }
        return "";
    }

    public boolean checkForLog(String expected, int timeout) throws InterruptedException {
        boolean logExists = false;
        for (int i = 0; i < timeout; ++i) {
            if (this.assertIfLogExists(expected)) {
                logExists = true;
                break;
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        return logExists;
    }

    public boolean checkForLog(String expected, int timeout, int numberofOccurrences) throws InterruptedException {
        for (int i = 0; i < timeout; ++i) {
            if (this.assertIfLogExists(expected, numberofOccurrences)) {
                return true;
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        return false;
    }

    public int getNumberOfOccurencesForLog(String expected) throws InterruptedException {
        return StringUtils.countMatches((String)this.getLogs(), (String)expected);
    }

    private Callable<Boolean> hasThreadStarted(final Thread thread) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return thread.isAlive();
            }
        };
    }
}

