/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.extensions.servers.jmsserver.client.JMSQueueMessageConsumer;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfigurationProvider;
import org.wso2.carbon.integration.common.admin.client.ApplicationAdminClient;
import org.wso2.esb.integration.common.clients.mediation.MessageStoreAdminClient;
import org.wso2.esb.integration.common.extensions.carbonserver.CarbonServerExtension;
import org.wso2.esb.integration.common.utils.CarbonLogReader;

public class Utils {
    private static Log log = LogFactory.getLog(Utils.class);

    public static OMElement getSimpleQuoteRequest(String symbol) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement omGetQuote = fac.createOMElement("getSimpleQuote", omNs);
        OMElement value1 = fac.createOMElement("symbol", omNs);
        value1.addChild((OMNode)fac.createOMText((OMContainer)omGetQuote, symbol));
        omGetQuote.addChild((OMNode)value1);
        return omGetQuote;
    }

    public static OMElement getCustomQuoteRequest(String symbol) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples", "ns");
        OMElement chkPrice = factory.createOMElement("CheckPriceRequest", ns);
        OMElement code = factory.createOMElement("Code", ns);
        chkPrice.addChild((OMNode)code);
        code.setText(symbol);
        return chkPrice;
    }

    public static OMElement getStockQuoteRequest(String symbol) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getQuote", omNs);
        OMElement value1 = fac.createOMElement("request", omNs);
        OMElement value2 = fac.createOMElement("symbol", omNs);
        value2.addChild((OMNode)fac.createOMText((OMContainer)value1, symbol));
        value1.addChild((OMNode)value2);
        method.addChild((OMNode)value1);
        return method;
    }

    public static OMElement getIncorrectRequest(String stringValue) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://echo.services.core.carbon.wso2.org", "echo");
        OMElement method = fac.createOMElement("echoInt", omNs);
        OMElement value1 = fac.createOMElement("in", omNs);
        value1.setText(stringValue);
        method.addChild((OMNode)value1);
        return method;
    }

    public static OMElement getCustomPayload(String symbol) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement payload = fac.createOMElement("getQuote", omNs);
        OMElement request = fac.createOMElement("request", omNs);
        OMElement code = fac.createOMElement("Code", omNs);
        code.setText(symbol);
        request.addChild((OMNode)code);
        payload.addChild((OMNode)request);
        return payload;
    }

    public static void shutdownFailsafe(int port) throws IOException {
        try {
            String processId;
            Process p = Runtime.getRuntime().exec("lsof -Pi tcp:" + port);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            reader.readLine();
            String line = reader.readLine();
            if (line != null && (processId = (line = line.trim()).split(" +")[1]) != null) {
                String killStr = "kill -9 " + processId;
                Runtime.getRuntime().exec(killStr);
            }
        }
        catch (IOException e) {
            throw new IOException("Error killing the process which uses the port " + port, e);
        }
    }

    public static boolean isQueueEmpty(String queueName) throws Exception {
        String poppedMessage;
        JMSQueueMessageConsumer consumer = new JMSQueueMessageConsumer(JMSBrokerConfigurationProvider.getInstance().getBrokerConfiguration());
        try {
            consumer.connect(queueName);
            poppedMessage = consumer.popMessage();
        }
        finally {
            consumer.disconnect();
        }
        return poppedMessage == null;
    }

    public static boolean assertIfSystemLogContains(CarbonLogReader carbonLogReader, String expected) {
        boolean matchFound = false;
        long startTime = System.currentTimeMillis();
        while (!matchFound && System.currentTimeMillis() - startTime < 10000L) {
            matchFound = Utils.assertIfLogExists(carbonLogReader, expected);
        }
        return matchFound;
    }

    private static boolean assertIfLogExists(CarbonLogReader carbonLogReader, String expected) {
        boolean matchFound = false;
        if (carbonLogReader != null && carbonLogReader.getLogs().contains(expected)) {
            carbonLogReader.stop();
            matchFound = true;
        }
        return matchFound;
    }

    public static boolean logExists(CarbonLogReader logReader, String expected, int timeout) throws InterruptedException {
        boolean logExists = false;
        for (int i = 0; i < timeout; ++i) {
            TimeUnit.SECONDS.sleep(1L);
            if (!logReader.getLogs().contains(expected)) continue;
            logExists = true;
            logReader.stop();
            break;
        }
        return logExists;
    }

    public static boolean checkForLog(CarbonLogReader logReader, String expected, int timeout) throws InterruptedException {
        boolean logExists = false;
        for (int i = 0; i < timeout; ++i) {
            TimeUnit.SECONDS.sleep(1L);
            if (!logReader.getLogs().contains(expected)) continue;
            logExists = true;
            break;
        }
        return logExists;
    }

    public static boolean waitForMessageCount(MessageStoreAdminClient messageStoreAdminClient, String messageStoreName, int expectedCount, long timeout) throws InterruptedException, RemoteException {
        boolean messageCountFound = false;
        for (long elapsedTime = 0L; elapsedTime < timeout && !messageCountFound; elapsedTime += 500L) {
            Thread.sleep(500L);
            messageCountFound = messageStoreAdminClient.getMessageCount(messageStoreName) == expectedCount;
        }
        return messageCountFound;
    }

    public static boolean isCarFileDeployed(String carFileName, ApplicationAdminClient applicationAdminClient, int timeout) throws Exception {
        long time;
        log.info((Object)("waiting " + timeout + " millis for car deployment " + carFileName));
        boolean isCarFileDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)timeout) {
            Object[] applicationList = applicationAdminClient.listAllApplications();
            if (applicationList != null && ArrayUtils.contains((Object[])applicationList, (Object)carFileName)) {
                isCarFileDeployed = true;
                log.info((Object)("car file deployed in " + time + " mills"));
                return isCarFileDeployed;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isCarFileDeployed;
    }

    public static void deploySynapseConfiguration(OMElement config, String artifactName, ArtifactType type, boolean isRestartRequired) throws IOException {
        Utils.deploySynapseConfiguration(config, artifactName, type.getDirName(), isRestartRequired);
    }

    public static void deploySynapseConfiguration(OMElement config, String artifactName, String artifactType, boolean isRestartRequired) throws IOException {
        String directory = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "synapse-configs" + File.separator + "default" + File.separator + artifactType;
        String path = directory + File.separator + artifactName + ".xml";
        if (!Files.exists(FileSystems.getDefault().getPath(directory, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(FileSystems.getDefault().getPath(directory, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Error while creating the directory, " + directory + ".", e);
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(path);){
            config.serialize((OutputStream)outputStream);
            config.serialize((OutputStream)System.out);
            if (isRestartRequired) {
                CarbonServerExtension.restartServer();
            }
        }
        catch (IOException exception) {
            log.error((Object)"Error when creating file", (Throwable)exception);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error when serializing synapse config", (Throwable)e);
        }
    }

    public static void undeploySynapseConfiguration(String artifactName, ArtifactType type, boolean restartServer) {
        Utils.undeploySynapseConfiguration(artifactName, type.getDirName(), restartServer);
    }

    public static void undeploySynapseConfiguration(String artifactName, String artifactType) {
        Utils.undeploySynapseConfiguration(artifactName, artifactType, true);
    }

    public static void undeploySynapseConfiguration(String artifactName, String artifactType, boolean restartServer) {
        CarbonServerExtension.shutdownServer();
        String pathString = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "synapse-configs" + File.separator + "default" + File.separator + artifactType + File.separator + artifactName + ".xml";
        Path path = FileSystems.getDefault().getPath(pathString, new String[0]);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            log.error((Object)"Error while deleting the file", (Throwable)e);
        }
        if (restartServer) {
            CarbonServerExtension.restartServer();
        }
    }

    public static enum ArtifactType {
        API("api"),
        ENDPOINT("endpoints"),
        INBOUND_ENDPOINT("inbound-endpoints"),
        LOCAL_ENTRY("local-entries"),
        MESSAGE_PROCESSOR("message-processors"),
        MESSAGE_STORES("message-stores"),
        PROXY("proxy-services"),
        SEQUENCE("sequences"),
        TEMPLATE("templates");

        private String type;

        private ArtifactType(String type) {
            this.type = type;
        }

        public String getDirName() {
            return this.type;
        }
    }
}

