/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpServerRunner {
    private final SftpServer sftpServer;

    public SftpServerRunner(int port, String ftpFolderPath, String userName, String password) {
        this.sftpServer = new SftpServer(port, ftpFolderPath, userName, password);
    }

    public void start() {
        Thread thread = new Thread(this.sftpServer);
        thread.start();
    }

    public void stop() {
        this.sftpServer.stop();
    }

    private class SftpServer
    implements Runnable {
        private final Logger LOGGER = LoggerFactory.getLogger(SftpServer.class);
        private final SshServer sshd = SshServer.setUpDefaultServer();
        private final int port;
        private final String path;
        private final String ftpUser;
        private final String ftpPassword;

        SftpServer(int port, String path, String ftpUser, String ftpPassword) {
            this.port = port;
            this.path = path;
            this.ftpUser = ftpUser;
            this.ftpPassword = ftpPassword;
        }

        @Override
        public void run() {
            this.sshd.setPort(this.port);
            this.sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
            this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
            this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
            this.sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(Paths.get(this.path, new String[0])));
            this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

                public boolean authenticate(String username, String password, ServerSession session) {
                    return StringUtils.equals((CharSequence)username, (CharSequence)SftpServer.this.ftpUser) && StringUtils.equals((CharSequence)password, (CharSequence)SftpServer.this.ftpPassword);
                }
            });
            try {
                this.LOGGER.info("Starting SFTP server on port {}", (Object)this.port);
                this.sshd.start();
            }
            catch (IOException e) {
                this.LOGGER.error("Error starting SFTP server", (Throwable)e);
            }
        }

        private void stop() {
            try {
                this.sshd.stop();
            }
            catch (IOException e) {
                this.LOGGER.error("Error stopping SFTP server", (Throwable)e);
            }
        }
    }
}

