/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.esb.integration.common.utils.common.FileManager;

public class MicroRegistryManager {
    private HashMap<String, byte[]> backupResources = new LinkedHashMap<String, byte[]>();
    private static final String CONF_PATH = "conf:";
    private static final String GOV_PATH = "gov:";
    private static final Log log = LogFactory.getLog(MicroRegistryManager.class);

    public void addResource(String resourcePath, String sourcePath) throws MicroRegistryManagerException {
        this.updateResource(resourcePath, sourcePath, false);
    }

    public void addProperty(String filePath, String sourcePath, String propertyName, String value) throws MicroRegistryManagerException {
        this.updateProperty(filePath, sourcePath, propertyName, value, false);
    }

    public void updateResource(String resourcePath, String sourcePath, boolean backupOriginal) throws MicroRegistryManagerException {
        String relativePath;
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(System.getProperty("carbon.home")).append(File.separator).append("registry").append(File.separator);
        if (resourcePath.startsWith(CONF_PATH)) {
            relativePath = resourcePath.substring(5).replace('/', File.separatorChar);
            pathBuilder.append("config").append(relativePath);
        } else if (resourcePath.startsWith(GOV_PATH)) {
            relativePath = resourcePath.substring(4).replace('/', File.separatorChar);
            pathBuilder.append("governance").append(relativePath);
        } else {
            throw new MicroRegistryManagerException("Unknown resource path: " + resourcePath);
        }
        String targetPath = pathBuilder.toString();
        String message = " source:" + sourcePath + " to: " + targetPath;
        if (backupOriginal) {
            try {
                this.backupFile(targetPath);
            }
            catch (IOException e) {
                throw new MicroRegistryManagerException("Error occurred while taking backup of file: " + targetPath, e);
            }
        }
        try {
            FileManager.copyFile(Paths.get(sourcePath, new String[0]).toFile(), Paths.get(targetPath, new String[0]).toString());
            log.info((Object)("Successfully copied" + message));
        }
        catch (IOException e) {
            throw new MicroRegistryManagerException("Error occurred while copying" + message, e);
        }
    }

    public boolean checkResourceExist(String sourcePath, String resourcePath, String filename) throws Exception {
        try {
            String path = sourcePath + resourcePath + filename;
            return path.contains(filename);
        }
        catch (Exception e) {
            throw new Exception("Exception occurred while checking the registry resource file.", e);
        }
    }

    public void updateProperty(String collectionPath, String resourceName, String propertyName, String value, boolean backupOriginal) throws MicroRegistryManagerException {
        String relativePath;
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(System.getProperty("carbon.home")).append(File.separator).append("registry").append(File.separator);
        if (collectionPath.startsWith(CONF_PATH)) {
            relativePath = collectionPath.substring(5).replace('/', File.separatorChar);
            pathBuilder.append("config").append(relativePath);
        } else if (collectionPath.startsWith(GOV_PATH)) {
            relativePath = collectionPath.substring(4).replace('/', File.separatorChar);
            pathBuilder.append("governance").append(relativePath);
        } else {
            throw new MicroRegistryManagerException("Unknown resource path: " + collectionPath);
        }
        String targetPath = pathBuilder.toString();
        String propertiesFileName = resourceName.split("/")[0] + ".properties";
        String message = " property name:" + propertyName + " to: " + targetPath;
        boolean isExists = new File(targetPath + resourceName).isFile();
        try {
            if (!isExists) {
                new File(targetPath + resourceName).createNewFile();
                new File(targetPath + propertiesFileName).createNewFile();
            }
            if (backupOriginal) {
                this.backupFile(targetPath);
            }
            Properties prop = new Properties();
            if (isExists) {
                FileInputStream input = new FileInputStream(targetPath + propertiesFileName);
                prop.load(input);
            }
            FileOutputStream output = new FileOutputStream(targetPath + propertiesFileName);
            prop.setProperty(propertyName, value);
            prop.store(output, null);
        }
        catch (IOException e) {
            throw new MicroRegistryManagerException("Error occurred while adding property" + message, e);
        }
    }

    public String getProperty(String collectionPath, String resourceName, String propertyName) throws MicroRegistryManagerException {
        String string;
        String relativePath;
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(System.getProperty("carbon.home")).append(File.separator).append("registry").append(File.separator);
        if (collectionPath.startsWith(CONF_PATH)) {
            relativePath = collectionPath.substring(5).replace('/', File.separatorChar);
            pathBuilder.append("config").append(relativePath);
        } else if (collectionPath.startsWith(GOV_PATH)) {
            relativePath = collectionPath.substring(4).replace('/', File.separatorChar);
            pathBuilder.append("governance").append(relativePath);
        } else {
            throw new MicroRegistryManagerException("Unknown resource path: " + collectionPath);
        }
        String targetPath = pathBuilder.toString();
        String message = " get property:" + propertyName + " from: " + targetPath;
        FileInputStream input = new FileInputStream(targetPath + resourceName + ".properties");
        try {
            Properties prop = new Properties();
            prop.load(input);
            string = prop.getProperty(propertyName);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MicroRegistryManagerException("Error occurred while getting property" + message, e);
            }
        }
        ((InputStream)input).close();
        return string;
    }

    public void restoreOriginalResources() throws MicroRegistryManagerException {
        for (Map.Entry<String, byte[]> backupEntry : this.backupResources.entrySet()) {
            this.restoreFile(backupEntry.getKey(), backupEntry.getValue());
            this.backupResources.remove(backupEntry.getKey());
        }
    }

    private void backupFile(String pathToFile) throws IOException {
        File sourceFile = new File(pathToFile);
        if (sourceFile.exists() && sourceFile.isFile()) {
            this.backupResources.put(pathToFile, Files.readAllBytes(sourceFile.toPath()));
        }
    }

    private void restoreFile(String path, byte[] data) throws MicroRegistryManagerException {
        try {
            Files.write(Paths.get(path, new String[0]), data, StandardOpenOption.WRITE);
            log.info((Object)("Successfully restored file: " + path));
        }
        catch (IOException e) {
            throw new MicroRegistryManagerException("Error occurred while restoring file : " + path, e);
        }
    }

    public class MicroRegistryManagerException
    extends Exception {
        public MicroRegistryManagerException() {
        }

        public MicroRegistryManagerException(String message) {
            super(message);
        }

        public MicroRegistryManagerException(String message, Throwable cause) {
            super(message, cause);
        }

        public MicroRegistryManagerException(Throwable cause) {
            super(cause);
        }
    }
}

