/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.carbon.aarservices.stub.ExceptionException;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.esb.integration.common.clients.aar.services.AARServiceUploaderClient;
import org.wso2.esb.integration.common.clients.service.mgt.ServiceAdminClient;

public class ServiceDeploymentUtil {
    private static Log log = LogFactory.getLog(ServiceDeploymentUtil.class);

    public static void deployArrService(String backEndUrl, String sessionCookie, String serviceName, String serviceFilePath, int deploymentDelay) throws RemoteException, MalformedURLException, LoginAuthenticationExceptionException, ExceptionException {
        AARServiceUploaderClient adminServiceAARServiceUploader = new AARServiceUploaderClient(backEndUrl, sessionCookie);
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        if (adminServiceService.isServiceExists(serviceName)) {
            adminServiceService.deleteService(new String[]{serviceName});
            ServiceDeploymentUtil.isServiceUnDeployed(backEndUrl, sessionCookie, serviceName, deploymentDelay);
        }
        adminServiceAARServiceUploader.uploadAARFile(serviceName + ".aar", serviceFilePath, "");
        Assert.assertTrue((boolean)ServiceDeploymentUtil.isServiceDeployed(backEndUrl, sessionCookie, serviceName, deploymentDelay), (String)(serviceName + " deployment failed in Application Server"));
    }

    public static boolean isServiceDeployed(String backEndUrl, String sessionCookie, String serviceName, int deploymentDelay) throws RemoteException {
        long time;
        log.info((Object)("waiting " + deploymentDelay + " millis for Service deployment " + serviceName));
        boolean isServiceDeployed = false;
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)deploymentDelay) {
            if (adminServiceService.isServiceExists(serviceName)) {
                isServiceDeployed = true;
                log.info((Object)(serviceName + " Service Deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeployed;
    }

    public static boolean isServiceUnDeployed(String backEndUrl, String sessionCookie, String serviceName, int deploymentDelay) throws RemoteException {
        long time;
        log.info((Object)("waiting " + deploymentDelay + " millis for Service undeployment"));
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        boolean isServiceDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)deploymentDelay) {
            if (!adminServiceService.isServiceExists(serviceName)) {
                isServiceDeleted = true;
                log.info((Object)(serviceName + " Service undeployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeleted;
    }

    public static boolean isServiceWSDlExist(String serviceUrl, long synchronizingDelay) throws Exception {
        long time;
        log.info((Object)("waiting " + synchronizingDelay + " millis for Proxy deployment in worker"));
        boolean isServiceDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < synchronizingDelay) {
            if (ServiceDeploymentUtil.isWSDLAvailable(serviceUrl)) {
                isServiceDeployed = true;
                log.info((Object)("Proxy Deployed in " + time + " millis in worker"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeployed;
    }

    public static boolean isServiceWSDlNotExist(String serviceUrl, long synchronizingDelay) throws Exception {
        long time;
        log.info((Object)("waiting " + synchronizingDelay + " millis for Proxy undeployment in worker"));
        boolean isServiceUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < synchronizingDelay) {
            if (!ServiceDeploymentUtil.isWSDLAvailable(serviceUrl)) {
                isServiceUnDeployed = true;
                log.info((Object)("Proxy UnDeployed in " + time + " millis in worker"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceUnDeployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWSDLAvailable(String serviceEndpoint) throws IOException {
        URL url = new URL(serviceEndpoint + "?wsdl");
        boolean isWsdlExist = false;
        BufferedReader rd = null;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.setReadTimeout(6000);
        try {
            String line;
            conn.connect();
            StringBuilder sb = new StringBuilder();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                sb.append(line);
                if (!sb.toString().contains("wsdl:definitions")) continue;
                isWsdlExist = true;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return isWsdlExist;
    }

    public void unDeployArrService(String backEndUrl, String sessionCookie, String serviceName, int deploymentDelay) throws RemoteException, MalformedURLException, LoginAuthenticationExceptionException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        if (adminServiceService.isServiceExists(serviceName)) {
            adminServiceService.deleteService(new String[]{serviceName});
            ServiceDeploymentUtil.isServiceUnDeployed(backEndUrl, sessionCookie, serviceName, deploymentDelay);
        }
    }
}

