/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class FIXClient {
    private String addUrl = null;
    private String trpUrl = null;
    private String prxyUrl = null;
    private String symbol;
    private String mode;
    private String qty;
    private String repo;
    private Options options = new Options();
    private ServiceClient serviceClient;
    private ConfigurationContext configContext = null;
    private String pathToRepo;

    public FIXClient() throws IOException {
        this.repo = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "clients";
        this.pathToRepo = new File(this.repo).getCanonicalPath();
    }

    public String send(String symbol, String mode, String qty, String addUrl, String trpUrl, String prxUrl) throws Exception {
        this.setSymbol(symbol);
        this.setMode(mode);
        this.setQty(qty);
        this.setAddUrl(addUrl);
        this.setTrpUrl(trpUrl);
        this.setPrxyUrl(prxUrl);
        String side = "1";
        if (this.getMode().equals("sell")) {
            side = "2";
        }
        if (this.pathToRepo != null && !"null".equals(this.pathToRepo)) {
            this.configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.pathToRepo, null);
            this.serviceClient = new ServiceClient(this.configContext, null);
        } else {
            this.serviceClient = new ServiceClient();
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement message = factory.createOMElement("message", null);
        message.addChild((OMNode)this.getHeader(factory));
        message.addChild((OMNode)this.getBody(factory, this.getSymbol(), side, this.getQty()));
        message.addChild((OMNode)factory.createOMElement("trailer", null));
        if (this.getAddUrl() != null && !"null".equals(this.getAddUrl())) {
            this.serviceClient.engageModule("addressing");
            this.options.setTo(new EndpointReference(this.getAddUrl()));
        }
        if (this.getTrpUrl() != null && !"null".equals(this.getTrpUrl())) {
            this.options.setProperty("TransportURL", (Object)this.getTrpUrl());
        }
        if (this.getPrxyUrl() != null && !"null".equals(this.getPrxyUrl())) {
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            URL url = new URL(this.getPrxyUrl());
            proxyProperties.setProxyName(url.getHost());
            proxyProperties.setProxyPort(url.getPort());
            proxyProperties.setUserName("");
            proxyProperties.setPassWord("");
            proxyProperties.setDomain("");
            this.options.setProperty("PROXY", (Object)proxyProperties);
        }
        this.options.setAction("urn:mediate");
        this.serviceClient.setOptions(this.options);
        OMElement response = this.serviceClient.sendReceive(message);
        Thread.sleep(5000L);
        try {
            if (this.configContext != null) {
                this.configContext.terminate();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return response.toString();
    }

    private OMElement getHeader(OMFactory factory) {
        OMElement header = factory.createOMElement("header", null);
        OMElement msgType = factory.createOMElement("field", null);
        msgType.addAttribute(factory.createOMAttribute("id", null, "35"));
        factory.createOMText((OMContainer)msgType, "D");
        header.addChild((OMNode)msgType);
        OMElement sendingTime = factory.createOMElement("field", null);
        sendingTime.addAttribute(factory.createOMAttribute("id", null, "52"));
        factory.createOMText((OMContainer)sendingTime, new Date().toString());
        header.addChild((OMNode)sendingTime);
        return header;
    }

    private OMElement getBody(OMFactory factory, String text, String mode, String qtyValue) {
        OMElement body = factory.createOMElement("body", null);
        OMElement clordID = factory.createOMElement("field", null);
        clordID.addAttribute(factory.createOMAttribute("id", null, "11"));
        factory.createOMText((OMContainer)clordID, "122333");
        body.addChild((OMNode)clordID);
        OMElement handleIns = factory.createOMElement("field", null);
        handleIns.addAttribute(factory.createOMAttribute("id", null, "21"));
        factory.createOMText((OMContainer)handleIns, "1");
        body.addChild((OMNode)handleIns);
        OMElement qty = factory.createOMElement("field", null);
        qty.addAttribute(factory.createOMAttribute("id", null, "38"));
        factory.createOMText((OMContainer)qty, qtyValue);
        body.addChild((OMNode)qty);
        OMElement ordType = factory.createOMElement("field", null);
        ordType.addAttribute(factory.createOMAttribute("id", null, "40"));
        factory.createOMText((OMContainer)ordType, "1");
        body.addChild((OMNode)ordType);
        OMElement side = factory.createOMElement("field", null);
        side.addAttribute(factory.createOMAttribute("id", null, "54"));
        factory.createOMText((OMContainer)side, mode);
        body.addChild((OMNode)side);
        OMElement symbol = factory.createOMElement("field", null);
        symbol.addAttribute(factory.createOMAttribute("id", null, "55"));
        factory.createOMText((OMContainer)symbol, text);
        body.addChild((OMNode)symbol);
        OMElement timeInForce = factory.createOMElement("field", null);
        timeInForce.addAttribute(factory.createOMAttribute("id", null, "59"));
        factory.createOMText((OMContainer)timeInForce, "0");
        body.addChild((OMNode)timeInForce);
        return body;
    }

    public String getAddUrl() {
        return this.addUrl;
    }

    public void setAddUrl(String addUrl) {
        this.addUrl = addUrl;
    }

    public String getTrpUrl() {
        return this.trpUrl;
    }

    public void setTrpUrl(String trpUrl) {
        this.trpUrl = trpUrl;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getQty() {
        return this.qty;
    }

    public void setQty(String qty) {
        this.qty = qty;
    }

    public String getPrxyUrl() {
        return this.prxyUrl;
    }

    public void setPrxyUrl(String prxyUrl) {
        this.prxyUrl = prxyUrl;
    }
}

