/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.esb.integration.common.utils.clients.ResponseData;

public class LoadBalanceSessionFullClient {
    protected static final Log log = LogFactory.getLog(LoadBalanceSessionFullClient.class);
    protected ServiceClient serviceClient;
    private static final String DEFAULT_CLIENT_REPO = "client_repo";
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";
    private SOAPEnvelope[] envelopes = null;
    private long sleepTime = -1L;

    public LoadBalanceSessionFullClient() throws IOException {
        this.init();
        this.buildSoapEnvelopesWithClientSession();
    }

    private void init() throws IOException {
        String repositoryPath = System.getProperty("carbon.home") + File.separator + "samples" + File.separator + "axis2Client" + File.separator + DEFAULT_CLIENT_REPO;
        File repository = new File(repositoryPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Axis2 repository path: " + repository.getAbsolutePath()));
        }
        ConfigurationContext configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository.getCanonicalPath(), null);
        this.serviceClient = new ServiceClient(configurationContext, null);
        log.info((Object)"LoadBalanceSessionFullClient initialized successfully...");
    }

    private void buildSoapEnvelopesWithClientSession() {
        Date date = new Date();
        SOAPEnvelope env1 = this.buildSoapEnvelope("" + (date.getTime() + 10L), "v1");
        SOAPEnvelope env2 = this.buildSoapEnvelope("" + (date.getTime() + 20L), "v1");
        SOAPEnvelope env3 = this.buildSoapEnvelope("" + (date.getTime() + 30L), "v1");
        this.envelopes = new SOAPEnvelope[]{env1, env2, env3};
    }

    public List<ResponseData> sendLoadBalanceRequest(String trpUrl, String addUrl, String prxUrl, int iterations) throws AxisFault {
        this.updateServiceClientOptions(trpUrl, addUrl, prxUrl);
        return this.makeRequest(null, iterations, this.sleepTime, this.envelopes, this.serviceClient);
    }

    public List<ResponseData> sendLoadBalanceRequest(String trpUrl, String addUrl, String prxUrl, String session, int iterations) throws AxisFault {
        this.updateServiceClientOptions(trpUrl, addUrl, prxUrl);
        return this.makeRequest(session, iterations, this.sleepTime, this.envelopes, this.serviceClient);
    }

    public List<ResponseData> sendLoadBalanceRequest(String trpUrl, String addUrl, String prxUrl, String session, int iterations, long sleepTime) throws AxisFault {
        this.updateServiceClientOptions(trpUrl, addUrl, prxUrl);
        return this.makeRequest(session, iterations, sleepTime, this.envelopes, this.serviceClient);
    }

    private void updateServiceClientOptions(String trpUrl, String addUrl, String prxUrl) throws AxisFault {
        Options options = new Options();
        options.setTo(new EndpointReference(trpUrl));
        options.setAction("urn:sampleOperation");
        options.setTimeOutInMilliSeconds(10000000L);
        if (addUrl != null && !"null".equals(addUrl)) {
            this.serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
        }
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        } else {
            this.serviceClient.engageModule("addressing");
        }
        this.serviceClient.engageModule("addressing");
        if (prxUrl != null && !"null".equals(prxUrl)) {
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            try {
                URL url = new URL(prxUrl);
                proxyProperties.setProxyName(url.getHost());
                proxyProperties.setProxyPort(url.getPort());
                proxyProperties.setUserName("");
                proxyProperties.setPassWord("");
                proxyProperties.setDomain("");
                options.setProperty("PROXY", (Object)proxyProperties);
            }
            catch (MalformedURLException e) {
                String msg = "Error while creating proxy URL";
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        this.serviceClient.setOptions(options);
    }

    private List<ResponseData> makeRequest(String session, int iterations, long sleepTime, SOAPEnvelope[] envelopes, ServiceClient client) throws AxisFault {
        boolean httpSession;
        ArrayList<ResponseData> responseList = new ArrayList<ResponseData>();
        int i = 0;
        String[] cookies = new String[3];
        boolean bl = httpSession = session != null && "http".equals(session);
        while (i < iterations) {
            ++i;
            if (sleepTime != -1L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            MessageContext messageContext = new MessageContext();
            int sessionNumber = this.getSessionTurn(envelopes.length);
            messageContext.setEnvelope(envelopes[sessionNumber]);
            int cookieNumber = this.getSessionTurn(cookies.length);
            String cookie = cookies[cookieNumber];
            if (httpSession) {
                this.setSessionID(messageContext, cookie);
            }
            try {
                OperationClient op = client.createClient(ServiceClient.ANON_OUT_IN_OP);
                op.addMessageContext(messageContext);
                op.execute(true);
                MessageContext responseContext = op.getMessageContext("In");
                String receivedCookie = this.extractSessionID(responseContext);
                String receivedSetCookie = this.getSetCookieHeader(responseContext);
                if (httpSession && receivedSetCookie != null && !"".equals(receivedSetCookie)) {
                    cookies[cookieNumber] = receivedCookie;
                }
                SOAPEnvelope responseEnvelope = responseContext.getEnvelope();
                OMElement vElement = responseEnvelope.getBody().getFirstChildWithName(new QName("Value"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Request: " + i + " with Session ID: " + (httpSession ? cookie : Integer.valueOf(sessionNumber)) + " ---- " + "Response : with  " + (httpSession && receivedCookie != null ? (receivedSetCookie != null ? receivedSetCookie : receivedCookie) : " ") + " " + vElement.getText()));
                }
                responseList.add(new ResponseData(true, "" + (httpSession ? cookie : Integer.valueOf(sessionNumber)), vElement.getText()));
            }
            catch (AxisFault axisFault) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Request with session id " + (httpSession ? cookie : Integer.valueOf(sessionNumber))), (Throwable)axisFault);
                }
                responseList.add(new ResponseData(false, "" + (httpSession ? cookie : Integer.valueOf(sessionNumber)), axisFault.getMessage()));
            }
        }
        return responseList;
    }

    private int getSessionTurn(int max) {
        Random random = new Random();
        return random.nextInt(max);
    }

    protected String extractSessionID(MessageContext axis2MessageContext) {
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o instanceof Map) {
            Map headerMap = (Map)o;
            String cookie = (String)headerMap.get(SET_COOKIE);
            cookie = cookie == null ? (String)headerMap.get(COOKIE) : cookie.split(";")[0];
            return cookie;
        }
        return null;
    }

    protected String getSetCookieHeader(MessageContext axis2MessageContext) {
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o instanceof Map) {
            Map headerMap = (Map)o;
            return (String)headerMap.get(SET_COOKIE);
        }
        return null;
    }

    protected void setSessionID(MessageContext axis2MessageContext, String value) {
        if (value == null) {
            return;
        }
        HashMap<String, String> map = (HashMap<String, String>)axis2MessageContext.getProperty("HTTP_HEADERS");
        if (map == null) {
            map = new HashMap<String, String>();
            axis2MessageContext.setProperty("HTTP_HEADERS", map);
        }
        map.put(COOKIE, value);
    }

    private SOAPEnvelope buildSoapEnvelope(String clientID, String value) {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope envelope = soapFactory.createSOAPEnvelope();
        SOAPHeader header = soapFactory.createSOAPHeader();
        envelope.addChild((OMNode)header);
        OMNamespace synNamespace = soapFactory.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
        OMElement clientIDElement = soapFactory.createOMElement("ClientID", synNamespace);
        clientIDElement.setText(clientID);
        header.addChild((OMNode)clientIDElement);
        SOAPBody body = soapFactory.createSOAPBody();
        envelope.addChild((OMNode)body);
        OMElement valueElement = soapFactory.createOMElement("Value", null);
        valueElement.setText(value);
        body.addChild((OMNode)valueElement);
        return envelope;
    }
}

