/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.DataBridge;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.Utils.AgentSession;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.definitionstore.InMemoryStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.receiver.thrift.ThriftDataReceiver;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.esb.integration.common.utils.servers.KeyStoreUtil;

public class ThriftServer
implements Runnable {
    private static Log log = LogFactory.getLog(ThriftServer.class);
    private final String FILE_STREAM_DEFINITION_EXT = ".json";
    private AbstractStreamDefinitionStore streamDefinitionStore = new InMemoryStreamDefinitionStore();
    private ThriftDataReceiver thriftDataReceiver;
    private boolean eventReceived = false;
    private AtomicLong msgCount = new AtomicLong(0L);
    private String testCaseResourceFolderName;
    private int listeningPort;
    private List<Event> preservedEventList = null;
    private boolean isPreservingEvents;

    public ThriftServer(String testCaseResourceFolderName, int listeningPort, boolean isPreservingEvents) {
        this.testCaseResourceFolderName = testCaseResourceFolderName;
        this.listeningPort = listeningPort;
        this.isPreservingEvents = isPreservingEvents;
    }

    public void startServer() throws DataBridgeException, StreamDefinitionStoreException {
        this.msgCount.set(0L);
        this.start(this.listeningPort);
    }

    public void start(int receiverPort) throws DataBridgeException, StreamDefinitionStoreException {
        KeyStoreUtil.setKeyStoreParams();
        DataBridge databridge = new DataBridge(new AuthenticationHandler(){

            public boolean authenticate(String userName, String password) {
                return true;
            }

            public String getTenantDomain(String userName) {
                return "admin";
            }

            public int getTenantId(String s) throws UserStoreException {
                return -1234;
            }

            public void initContext(AgentSession agentSession) {
            }

            public void destroyContext(AgentSession agentSession) {
            }
        }, this.streamDefinitionStore, this.getResourceFilePath("StatisticTestResources", "data-bridge-config.xml"));
        this.thriftDataReceiver = new ThriftDataReceiver(receiverPort, (DataBridgeReceiverService)databridge);
        for (StreamDefinition streamDefinition : this.loadStreamDefinitions()) {
            this.streamDefinitionStore.saveStreamDefinitionToStore(streamDefinition, -1234);
            log.info((Object)("StreamDefinition of '" + streamDefinition.getStreamId() + "' added to store"));
        }
        databridge.subscribe(new AgentCallback(){

            public void definedStream(StreamDefinition streamDefinition, int tenantId) {
                log.info((Object)("Added StreamDefinition " + streamDefinition));
            }

            public void removeStream(StreamDefinition streamDefinition, int tenantId) {
                log.info((Object)("Removed StreamDefinition " + streamDefinition));
            }

            public void receive(List<Event> eventList, Credentials credentials) {
                log.info((Object)("eventListSize=" + eventList.size() + " eventList " + eventList + " for username " + credentials.getUsername()));
                ThriftServer.this.eventReceived = true;
                ThriftServer.this.msgCount.addAndGet(eventList.size());
                if (ThriftServer.this.isPreservingEvents) {
                    if (ThriftServer.this.preservedEventList == null) {
                        ThriftServer.this.preservedEventList = new ArrayList();
                    }
                    ThriftServer.this.preservedEventList.addAll(eventList);
                }
            }
        });
        this.thriftDataReceiver.start("0.0.0.0");
        log.info((Object)"Test Server Started.");
    }

    public void stop() {
        if (!this.eventReceived) {
            log.warn((Object)"Events did not received.");
        }
        this.thriftDataReceiver.stop();
        log.info((Object)"Test Server Stopped.");
    }

    @Override
    public void run() {
        try {
            this.startServer();
        }
        catch (DataBridgeException e) {
            log.error((Object)"Cannot start the test server.", (Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            log.error((Object)"StreamDefinition cannot be added to the store.", (Throwable)e);
        }
    }

    public long getMsgCount() {
        return this.msgCount.get();
    }

    public List<Event> getPreservedEventList() {
        return this.preservedEventList;
    }

    public void resetMsgCount() {
        this.msgCount = new AtomicLong(0L);
    }

    public void resetPreservedEventList() {
        this.preservedEventList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StreamDefinition> loadStreamDefinitions() {
        String relativeFilePath = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "ESB" + File.separator + this.testCaseResourceFolderName;
        String directoryPath = relativeFilePath.replaceAll("[\\\\/]", Matcher.quoteReplacement(File.separator));
        GenericExtFilter filter = new GenericExtFilter(".json");
        File directory = new File(directoryPath);
        ArrayList<StreamDefinition> streamDefinitions = new ArrayList<StreamDefinition>();
        if (!directory.exists()) {
            log.error((Object)("Cannot load stream definitions from " + directory.getAbsolutePath() + " directory not exist"));
            return streamDefinitions;
        }
        if (!directory.isDirectory()) {
            log.error((Object)("Cannot load stream definitions from " + directory.getAbsolutePath() + " not a directory"));
            return streamDefinitions;
        }
        String[] listStreamDefinitionFiles = directory.list(filter);
        if (listStreamDefinitionFiles != null) {
            for (String fileEntry : listStreamDefinitionFiles) {
                BufferedReader bufferedReader = null;
                StringBuilder stringBuilder = new StringBuilder();
                String fullPathToStreamDefinitionFile = directoryPath + File.separator + fileEntry;
                try {
                    String line;
                    bufferedReader = new BufferedReader(new FileReader(fullPathToStreamDefinitionFile));
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line).append("\n");
                    }
                    StreamDefinition streamDefinition = EventDefinitionConverterUtils.convertFromJson((String)stringBuilder.toString().trim());
                    streamDefinitions.add(streamDefinition);
                }
                catch (IOException e) {
                    log.error((Object)("Error in reading file : " + fullPathToStreamDefinitionFile), (Throwable)e);
                }
                catch (MalformedStreamDefinitionException e) {
                    log.error((Object)("Error in converting Stream definition : " + e.getMessage()), (Throwable)e);
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("Error occurred when reading the file : " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        return streamDefinitions;
    }

    public String getResourceFilePath(String testCaseFolderName, String resourceFileName) {
        String relativeFilePath = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "ESB" + File.separator + testCaseFolderName + File.separator + resourceFileName;
        return relativeFilePath.replaceAll("[\\\\/]", Matcher.quoteReplacement(File.separator));
    }

    public void waitToReceiveEvents(int maxWaitTime, int expectedCount) {
        for (int i = 0; i < maxWaitTime && this.msgCount.get() < (long)expectedCount; i += 5000) {
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public class GenericExtFilter
    implements FilenameFilter {
        private String ext;

        public GenericExtFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

