/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.File;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.JMSBrokerController;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfigurationProvider;
import org.wso2.esb.integration.common.utils.ESBIntegrationTest;
import org.wso2.esb.integration.common.utils.common.ServerConfigurationManager;
import org.wso2.esb.integration.common.utils.common.TestConfigurationProvider;

public class ActiveMQServer
extends ESBIntegrationTest {
    private JMSBrokerController activeMqBroker;
    private ServerConfigurationManager serverManager = null;
    private final String ACTIVEMQ_BROKER = "activemq-broker-5.9.1.jar";
    private final String GERONIMO_J2EE_MANAGEMENT = "geronimo-j2ee-management_1.1_spec-1.0.1.jar";
    private final String GERONIMO_JMS = "geronimo-jms_1.1_spec-1.1.1.jar";
    private final String HAWTBUF = "hawtbuf-1.9.jar";
    private final String ACTIVEMQ_CLIENT = "activemq-client-5.9.1.jar";

    public void startJMSBrokerAndConfigureESB() throws Exception {
        this.context = new AutomationContext("ESB", TestUserMode.SUPER_TENANT_ADMIN);
        this.serverManager = new ServerConfigurationManager(this.context);
        this.activeMqBroker = new JMSBrokerController("localhost", this.getJMSBrokerConfiguration());
        if (!JMSBrokerController.isBrokerStarted()) {
            Assert.assertTrue((boolean)this.activeMqBroker.start(), (String)"JMS Broker(ActiveMQ) stating failed");
        }
        this.serverManager.copyToComponentLib(new File(TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "jar" + File.separator + "activemq-broker-5.9.1.jar"));
        this.serverManager.copyToComponentLib(new File(TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "jar" + File.separator + "geronimo-j2ee-management_1.1_spec-1.0.1.jar"));
        this.serverManager.copyToComponentLib(new File(TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "jar" + File.separator + "geronimo-jms_1.1_spec-1.1.1.jar"));
        this.serverManager.copyToComponentLib(new File(TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "jar" + File.separator + "hawtbuf-1.9.jar"));
        this.serverManager.copyToComponentLib(new File(TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "jar" + File.separator + "activemq-client-5.9.1.jar"));
        this.serverManager.applyConfiguration(new File(TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "jms" + File.separator + "transport" + File.separator + "axis2config" + File.separator + "activemq" + File.separator + "axis2.xml"));
    }

    public void stopJMSBrokerRevertESBConfiguration() throws Exception {
        try {
            Thread.sleep(10000L);
            if (this.serverManager != null) {
                this.serverManager.removeFromComponentLib("activemq-broker-5.9.1.jar");
                this.serverManager.removeFromComponentLib("geronimo-j2ee-management_1.1_spec-1.0.1.jar");
                this.serverManager.removeFromComponentLib("geronimo-jms_1.1_spec-1.1.1.jar");
                this.serverManager.removeFromComponentLib("hawtbuf-1.9.jar");
                this.serverManager.removeFromComponentLib("activemq-client-5.9.1.jar");
                this.serverManager.restoreToLastConfiguration();
            }
        }
        finally {
            if (this.activeMqBroker != null) {
                Assert.assertTrue((boolean)this.activeMqBroker.stop(), (String)"JMS Broker(ActiveMQ) Stopping failed");
            }
        }
    }

    private JMSBrokerConfiguration getJMSBrokerConfiguration() {
        return JMSBrokerConfigurationProvider.getInstance().getBrokerConfiguration();
    }
}

