/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.carbon.application.mgt.synapse.stub.ExceptionException;
import org.wso2.carbon.application.mgt.synapse.stub.types.carbon.SynapseApplicationMetadata;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.ContextUrls;
import org.wso2.carbon.automation.engine.context.beans.Tenant;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.inbound.stub.types.carbon.InboundEndpointDTO;
import org.wso2.carbon.integration.common.admin.client.CarbonAppUploaderClient;
import org.wso2.carbon.integration.common.admin.client.SecurityAdminServiceClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.mediation.library.stub.MediationLibraryAdminServiceException;
import org.wso2.carbon.mediation.library.stub.upload.types.carbon.LibraryFileItem;
import org.wso2.carbon.security.mgt.stub.config.SecurityAdminServiceSecurityConfigExceptionException;
import org.wso2.carbon.sequences.stub.types.SequenceEditorException;
import org.wso2.esb.integration.common.clients.application.mgt.SynapseApplicationAdminClient;
import org.wso2.esb.integration.common.clients.mediation.SynapseConfigAdminClient;
import org.wso2.esb.integration.common.utils.ESBTestCaseUtils;
import org.wso2.esb.integration.common.utils.EndpointGenerator;
import org.wso2.esb.integration.common.utils.ServiceDeploymentUtil;
import org.wso2.esb.integration.common.utils.clients.stockquoteclient.StockQuoteClient;
import org.wso2.esb.integration.common.utils.common.TestConfigurationProvider;
import org.xml.sax.SAXException;

public abstract class ESBIntegrationTest {
    protected Log log = LogFactory.getLog(this.getClass());
    protected StockQuoteClient axis2Client;
    protected ContextUrls contextUrls = new ContextUrls();
    protected String sessionCookie;
    protected OMElement synapseConfiguration = null;
    protected ESBTestCaseUtils esbUtils;
    private List<String> proxyServicesList = null;
    private List<String> sequencesList = null;
    private List<String> endpointsList = null;
    private List<String> localEntryList = null;
    private List<String> messageProcessorsList = null;
    private List<String> messageStoresList = null;
    private List<String> sequenceTemplateList = null;
    private List<String> apiList = null;
    private List<String> priorityExecutorList = null;
    private List<String[]> scheduledTaskList = null;
    private static final String synapsePathFormBaseUri = File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "synapse-configs" + File.separator + "default" + File.separator + "synapse.xml";
    protected AutomationContext context;
    protected Tenant tenantInfo;
    protected User userInfo;
    protected TestUserMode userMode;

    protected void init() throws Exception {
        this.userMode = TestUserMode.SUPER_TENANT_ADMIN;
        this.init(this.userMode);
    }

    protected void init(TestUserMode userMode) throws Exception {
        this.axis2Client = new StockQuoteClient();
        this.context = new AutomationContext("ESB", userMode);
        this.contextUrls = this.context.getContextUrls();
        this.sessionCookie = this.login(this.context);
        this.esbUtils = new ESBTestCaseUtils();
        this.tenantInfo = this.context.getContextTenant();
        this.userInfo = this.tenantInfo.getContextUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() throws Exception {
        try {
            if (this.synapseConfiguration != null) {
                this.esbUtils.deleteArtifact(this.synapseConfiguration, this.contextUrls.getBackEndUrl(), this.sessionCookie);
                if (this.context.getProductGroup().isClusterEnabled()) {
                    long deploymentDelay = Long.parseLong(this.context.getConfigurationValue("//deploymentDelay"));
                    Thread.sleep(deploymentDelay);
                    Iterator proxies = this.synapseConfiguration.getChildrenWithLocalName("proxy");
                    while (proxies.hasNext()) {
                        String proxy = ((OMElement)proxies.next()).getAttributeValue(new QName("name"));
                        Assert.assertTrue((boolean)this.isProxyWSDlNotExist(this.getProxyServiceURLHttp(proxy), deploymentDelay), (String)"UnDeployment Synchronizing failed in workers");
                        Assert.assertTrue((boolean)this.isProxyWSDlNotExist(this.getProxyServiceURLHttp(proxy), deploymentDelay), (String)"UnDeployment Synchronizing failed in workers");
                        Assert.assertTrue((boolean)this.isProxyWSDlNotExist(this.getProxyServiceURLHttp(proxy), deploymentDelay), (String)"UnDeployment Synchronizing failed in workers");
                    }
                }
            }
            this.deleteProxyServices();
            this.deleteSequences();
            this.deleteEndpoints();
            this.deleteMessageProcessors();
            this.deleteMessageStores();
            this.deleteSequenceTemplates();
            this.deleteLocalEntries();
            this.deleteApi();
            this.deletePriorityExecutors();
            this.deleteScheduledTasks();
            this.deleteInboundEndpoints();
        }
        finally {
            this.restoreSynapseConfig();
            this.synapseConfiguration = null;
            this.proxyServicesList = null;
            this.messageProcessorsList = null;
            this.proxyServicesList = null;
            this.sequencesList = null;
            this.endpointsList = null;
            this.localEntryList = null;
            this.apiList = null;
            this.priorityExecutorList = null;
            this.axis2Client.destroy();
            this.axis2Client = null;
            this.esbUtils = null;
            this.scheduledTaskList = null;
        }
    }

    protected String getMainSequenceURL() {
        String mainSequenceUrl = this.contextUrls.getServiceUrl();
        if (mainSequenceUrl.endsWith("/services")) {
            mainSequenceUrl = mainSequenceUrl.replace("/services", "");
        }
        if (!mainSequenceUrl.endsWith("/")) {
            mainSequenceUrl = mainSequenceUrl + "/";
        }
        return mainSequenceUrl;
    }

    protected String getProxyServiceURLHttp(String proxyServiceName) {
        return this.contextUrls.getServiceUrl() + "/" + proxyServiceName;
    }

    protected String getApiInvocationURL(String apiName) {
        return this.getMainSequenceURL() + apiName;
    }

    protected String getProxyServiceURLHttps(String proxyServiceName) {
        return this.contextUrls.getSecureServiceUrl() + "/" + proxyServiceName;
    }

    protected void loadSampleESBConfiguration(int sampleNo) throws Exception {
        OMElement synapseSample = this.esbUtils.loadESBSampleConfiguration(sampleNo);
        this.updateESBConfiguration(synapseSample);
    }

    protected OMElement loadSampleESBConfigurationWithoutApply(int sampleNo) throws Exception {
        return this.esbUtils.loadESBSampleConfiguration(sampleNo);
    }

    protected void loadESBConfigurationFromClasspath(String relativeFilePath) throws Exception {
        relativeFilePath = relativeFilePath.replaceAll("[\\\\/]", Matcher.quoteReplacement(File.separator));
        OMElement synapseConfig = this.esbUtils.loadResource(relativeFilePath);
        this.updateESBConfiguration(synapseConfig);
    }

    protected void deleteLibrary(String fullQualifiedName) throws MediationLibraryAdminServiceException, RemoteException {
        this.esbUtils.deleteLibrary(this.contextUrls.getBackEndUrl(), this.sessionCookie, fullQualifiedName);
    }

    protected String[] getAllImports() throws RemoteException {
        return this.esbUtils.getAllImports(this.contextUrls.getBackEndUrl(), this.sessionCookie);
    }

    protected void updateESBConfiguration(OMElement synapseConfig) throws Exception {
        if (this.synapseConfiguration == null) {
            this.synapseConfiguration = synapseConfig;
        } else {
            Iterator itr = synapseConfig.cloneOMElement().getChildElements();
            while (itr.hasNext()) {
                this.synapseConfiguration.addChild((OMNode)itr.next());
            }
        }
        this.esbUtils.updateESBConfiguration(this.setEndpoints(synapseConfig), this.contextUrls.getBackEndUrl(), this.sessionCookie);
        if (this.context.getProductGroup().isClusterEnabled()) {
            long deploymentDelay = Long.parseLong(this.context.getConfigurationValue("//deploymentDelay"));
            Thread.sleep(deploymentDelay);
            Iterator proxies = synapseConfig.getChildrenWithLocalName("proxy");
            while (proxies.hasNext()) {
                String proxy = ((OMElement)proxies.next()).getAttributeValue(new QName("name"));
                Assert.assertTrue((boolean)this.isProxyWSDlExist(this.getProxyServiceURLHttp(proxy), deploymentDelay), (String)"Deployment Synchronizing failed in workers");
                Assert.assertTrue((boolean)this.isProxyWSDlExist(this.getProxyServiceURLHttp(proxy), deploymentDelay), (String)"Deployment Synchronizing failed in workers");
                Assert.assertTrue((boolean)this.isProxyWSDlExist(this.getProxyServiceURLHttp(proxy), deploymentDelay), (String)"Deployment Synchronizing failed in workers");
            }
        }
    }

    protected void addProxyService(OMElement proxyConfig) throws Exception {
        String proxyName = proxyConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isProxyServiceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName)) {
            this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName);
        }
        if (this.proxyServicesList == null) {
            this.proxyServicesList = new ArrayList<String>();
        }
        this.proxyServicesList.add(proxyName);
        this.esbUtils.addProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(proxyConfig));
    }

    protected void addInboundEndpoint(OMElement inboundEndpoint) throws Exception {
        try {
            this.esbUtils.addInboundEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpoint);
        }
        catch (Exception e) {
            throw new Exception("Error when adding InboundEndpoint", e);
        }
    }

    protected void isInboundUndeployed(String inboundEndpoint) throws Exception {
        try {
            this.esbUtils.isInboundEndpointUndeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpoint);
        }
        catch (Exception e) {
            throw new Exception("Error when adding InboundEndpoint", e);
        }
    }

    protected void updateInboundEndpoint(OMElement inboundEndpoint) throws Exception {
        try {
            this.esbUtils.updateInboundEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpoint);
        }
        catch (Exception e) {
            throw new Exception("Error when adding InboundEndpoint", e);
        }
    }

    protected void isProxyNotDeployed(String proxyServiceName) throws Exception {
        Assert.assertFalse((boolean)this.esbUtils.isProxyDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName), (String)"Proxy Deployment failed or time out");
    }

    protected void deleteInboundEndpoints() throws Exception {
        try {
            InboundEndpointDTO[] inboundEndpointDTOs = this.esbUtils.getAllInboundEndpoints(this.contextUrls.getBackEndUrl(), this.sessionCookie);
            if (inboundEndpointDTOs != null) {
                for (InboundEndpointDTO inboundEndpointDTO : inboundEndpointDTOs) {
                    if (inboundEndpointDTO == null || inboundEndpointDTO.getName() == null) continue;
                    this.esbUtils.deleteInboundEndpointDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpointDTO.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error when deleting InboundEndpoint", e);
        }
    }

    protected void deleteInboundEndpointFromName(String name) throws Exception {
        try {
            this.esbUtils.deleteInboundEndpointDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, name);
        }
        catch (Exception e) {
            throw new Exception("Error when deleting InboundEndpoint", e);
        }
    }

    protected void isProxyDeployed(String proxyServiceName) throws Exception {
        Assert.assertTrue((boolean)this.esbUtils.isProxyDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName), (String)"Proxy Deployment failed or time out");
    }

    protected void deleteProxyService(String proxyServiceName) throws Exception {
        if (this.esbUtils.isProxyServiceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName)) {
            this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName);
            Assert.assertTrue((boolean)this.esbUtils.isProxyUnDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName), (String)"Proxy Deletion failed or time out");
        }
        if (this.proxyServicesList != null && this.proxyServicesList.contains(proxyServiceName)) {
            this.proxyServicesList.remove(proxyServiceName);
        }
    }

    protected void deleteSequence(String sequenceName) throws SequenceEditorException, RemoteException {
        if (this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName)) {
            this.esbUtils.deleteSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName);
        }
        if (this.sequencesList != null && this.sequencesList.contains(sequenceName)) {
            this.sequencesList.remove(sequenceName);
        }
    }

    protected void addSequence(OMElement sequenceConfig) throws Exception {
        String sequenceName = sequenceConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName)) {
            this.esbUtils.deleteSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName);
        }
        this.esbUtils.addSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(sequenceConfig));
        if (this.sequencesList == null) {
            this.sequencesList = new ArrayList<String>();
        }
        this.sequencesList.add(sequenceName);
    }

    protected void uploadConnector(String repoLocation, String strFileName) throws MalformedURLException, RemoteException {
        ArrayList<LibraryFileItem> uploadLibraryInfoList = new ArrayList<LibraryFileItem>();
        LibraryFileItem uploadedFileItem = new LibraryFileItem();
        uploadedFileItem.setDataHandler(new DataHandler(new URL("file:" + File.separator + File.separator + repoLocation + File.separator + strFileName)));
        uploadedFileItem.setFileName(strFileName);
        uploadedFileItem.setFileType("zip");
        uploadLibraryInfoList.add(uploadedFileItem);
        LibraryFileItem[] uploadServiceTypes = new LibraryFileItem[uploadLibraryInfoList.size()];
        uploadServiceTypes = uploadLibraryInfoList.toArray(uploadServiceTypes);
        this.esbUtils.uploadConnector(this.contextUrls.getBackEndUrl(), this.sessionCookie, uploadServiceTypes);
    }

    protected void updateConnectorStatus(String libQName, String libName, String packageName, String status) throws RemoteException {
        this.esbUtils.updateConnectorStatus(this.contextUrls.getBackEndUrl(), this.sessionCookie, libQName, libName, packageName, status);
    }

    protected void addEndpoint(OMElement endpointConfig) throws Exception {
        String endpointName = endpointConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpointName)) {
            this.esbUtils.deleteEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpointName);
        }
        this.esbUtils.addEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(endpointConfig));
        if (this.endpointsList == null) {
            this.endpointsList = new ArrayList<String>();
        }
        this.endpointsList.add(endpointName);
    }

    protected void addLocalEntry(OMElement localEntryConfig) throws Exception {
        String localEntryName = localEntryConfig.getAttributeValue(new QName("key"));
        if (this.esbUtils.isLocalEntryExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntryName)) {
            this.esbUtils.deleteLocalEntry(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntryName);
        }
        this.esbUtils.addLocalEntry(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntryConfig);
        if (this.localEntryList == null) {
            this.localEntryList = new ArrayList<String>();
        }
        this.localEntryList.add(localEntryName);
    }

    protected void addMessageProcessor(OMElement messageProcessorConfig) throws Exception {
        String messageProcessorName = messageProcessorConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isMessageProcessorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessorName)) {
            this.esbUtils.deleteMessageProcessor(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessorName);
        }
        this.esbUtils.addMessageProcessor(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(messageProcessorConfig));
        if (this.messageProcessorsList == null) {
            this.messageProcessorsList = new ArrayList<String>();
        }
        this.messageProcessorsList.add(messageProcessorName);
    }

    protected void addMessageStore(OMElement messageStoreConfig) throws Exception {
        String messageStoreName = messageStoreConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isMessageStoreExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStoreName)) {
            this.esbUtils.deleteMessageStore(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStoreName);
        }
        this.esbUtils.addMessageStore(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(messageStoreConfig));
        if (this.messageStoresList == null) {
            this.messageStoresList = new ArrayList<String>();
        }
        this.messageStoresList.add(messageStoreName);
    }

    protected void addSequenceTemplate(OMElement sequenceTemplate) throws Exception {
        String name = sequenceTemplate.getAttributeValue(new QName("name"));
        if (this.esbUtils.isSequenceTemplateExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, name)) {
            this.esbUtils.deleteSequenceTemplate(this.contextUrls.getBackEndUrl(), this.sessionCookie, name);
        }
        this.esbUtils.addSequenceTemplate(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(sequenceTemplate));
        if (this.sequenceTemplateList == null) {
            this.sequenceTemplateList = new ArrayList<String>();
        }
        this.sequenceTemplateList.add(name);
    }

    protected void addApi(OMElement api) throws Exception {
        String apiName = api.getAttributeValue(new QName("name"));
        if (this.esbUtils.isApiExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, apiName)) {
            this.esbUtils.deleteApi(this.contextUrls.getBackEndUrl(), this.sessionCookie, apiName);
        }
        this.esbUtils.addAPI(this.contextUrls.getBackEndUrl(), this.sessionCookie, api);
        if (this.apiList == null) {
            this.apiList = new ArrayList<String>();
        }
        this.apiList.add(apiName);
    }

    protected void addPriorityExecutor(OMElement priorityExecutor) throws Exception {
        String executorName = priorityExecutor.getAttributeValue(new QName("name"));
        if (this.esbUtils.isPriorityExecutorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, executorName)) {
            this.esbUtils.deletePriorityExecutor(this.contextUrls.getBackEndUrl(), this.sessionCookie, executorName);
        }
        this.esbUtils.addPriorityExecutor(this.contextUrls.getBackEndUrl(), this.sessionCookie, priorityExecutor);
        if (this.priorityExecutorList == null) {
            this.priorityExecutorList = new ArrayList<String>();
        }
        this.priorityExecutorList.add(executorName);
    }

    protected void addScheduledTask(OMElement task) throws Exception {
        String taskName = task.getAttributeValue(new QName("name"));
        String taskGroup = task.getAttributeValue(new QName("group"));
        if (this.esbUtils.isScheduleTaskExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, taskName)) {
            this.esbUtils.deleteScheduleTask(this.contextUrls.getBackEndUrl(), this.sessionCookie, taskName, taskGroup);
        }
        this.esbUtils.addScheduleTask(this.contextUrls.getBackEndUrl(), this.sessionCookie, task);
        if (this.scheduledTaskList == null) {
            this.scheduledTaskList = new ArrayList<String[]>();
        }
        this.scheduledTaskList.add(new String[]{taskName, taskGroup});
    }

    protected void applySecurity(String serviceName, int policyId, String[] userGroups) throws SecurityAdminServiceSecurityConfigExceptionException, RemoteException, InterruptedException {
        SecurityAdminServiceClient securityAdminServiceClient = new SecurityAdminServiceClient(this.contextUrls.getBackEndUrl(), this.sessionCookie);
        securityAdminServiceClient.applySecurity(serviceName, policyId + "", userGroups, new String[]{"wso2carbon.jks"}, "wso2carbon.jks");
        this.log.info((Object)("Security Scenario " + policyId + " Applied"));
        Thread.sleep(1000L);
    }

    protected void restoreSynapseConfig() throws Exception {
        String carbonHome = System.getProperty("carbon.home");
        String fullPath = carbonHome + synapsePathFormBaseUri;
        String defaultSynapseConfigPath = TestConfigurationProvider.getResourceLocation("ESB") + File.separator + "defaultconfigs" + File.separator + "synapse.xml";
        if (this.esbUtils.isFileEmpty(fullPath)) {
            try {
                this.log.info((Object)"Synapse config is empty copying Backup Config to the location.");
                ESBTestCaseUtils.copyFile(defaultSynapseConfigPath, fullPath);
            }
            catch (IOException exception) {
                throw new Exception("Exception occurred while restoring the default synapse configuration.", exception);
            }
        }
    }

    private void deleteMessageProcessors() {
        if (this.messageProcessorsList != null) {
            for (String messageProcessor : this.messageProcessorsList) {
                try {
                    if (!this.esbUtils.isMessageProcessorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessor)) continue;
                    this.esbUtils.deleteMessageProcessor(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessor);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Message Processor. " + e.getMessage()));
                }
            }
            this.messageProcessorsList.clear();
        }
    }

    private void deleteMessageStores() {
        if (this.messageStoresList != null) {
            for (String messageStore : this.messageStoresList) {
                try {
                    if (!this.esbUtils.isMessageStoreExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStore)) continue;
                    this.esbUtils.deleteMessageStore(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStore);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Message store. " + e.getMessage()));
                }
            }
            this.messageStoresList.clear();
        }
    }

    private void deleteSequences() {
        if (this.sequencesList != null) {
            for (String sequence : this.sequencesList) {
                if (sequence.equalsIgnoreCase("fault")) continue;
                try {
                    if (!this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequence)) continue;
                    this.esbUtils.deleteSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequence);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Sequence. " + e.getMessage()));
                }
            }
            this.sequencesList.clear();
        }
    }

    private void deleteProxyServices() {
        if (this.proxyServicesList != null) {
            for (String proxyName : this.proxyServicesList) {
                try {
                    if (!this.esbUtils.isProxyServiceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName)) continue;
                    this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Proxy. " + e.getMessage()));
                }
            }
            this.proxyServicesList.clear();
        }
    }

    private void deleteEndpoints() {
        if (this.endpointsList != null) {
            for (String endpoint : this.endpointsList) {
                try {
                    if (!this.esbUtils.isEndpointExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpoint)) continue;
                    this.esbUtils.deleteEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpoint);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Endpoint. " + e.getMessage()));
                }
            }
            this.endpointsList.clear();
        }
    }

    private void deleteLocalEntries() {
        if (this.localEntryList != null) {
            for (String localEntry : this.localEntryList) {
                try {
                    if (!this.esbUtils.isLocalEntryExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry)) continue;
                    this.esbUtils.deleteLocalEntry(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying LocalEntry. " + e.getMessage()));
                }
            }
            this.localEntryList.clear();
        }
    }

    private void deleteSequenceTemplates() {
        if (this.sequenceTemplateList != null) {
            for (String localEntry : this.sequenceTemplateList) {
                try {
                    if (!this.esbUtils.isSequenceTemplateExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry)) continue;
                    this.esbUtils.deleteSequenceTemplate(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Sequence Template. " + e.getMessage()));
                }
            }
            this.sequenceTemplateList.clear();
        }
    }

    private void deleteApi() {
        if (this.apiList != null) {
            for (String api : this.apiList) {
                try {
                    if (!this.esbUtils.isApiExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, api)) continue;
                    this.esbUtils.deleteApi(this.contextUrls.getBackEndUrl(), this.sessionCookie, api);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Api. " + e.getMessage()));
                }
            }
            this.apiList.clear();
        }
    }

    private void deletePriorityExecutors() {
        if (this.priorityExecutorList != null) {
            for (String executor : this.priorityExecutorList) {
                try {
                    if (!this.esbUtils.isPriorityExecutorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor)) continue;
                    this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Priority Executor. " + e.getMessage()));
                }
            }
            this.priorityExecutorList.clear();
        }
    }

    private void deleteScheduledTasks() {
        if (this.scheduledTaskList != null) {
            for (String[] executor : this.scheduledTaskList) {
                try {
                    if (!this.esbUtils.isScheduleTaskExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor[0])) continue;
                    this.esbUtils.deleteScheduleTask(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor[0], executor[1]);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying ScheduledTask Executor. " + e.getMessage()));
                }
            }
            this.scheduledTaskList.clear();
        }
    }

    protected void updateESBRegistry(String resourcePath) throws Exception {
        SynapseConfigAdminClient synapseConfigAdminClient = new SynapseConfigAdminClient(this.contextUrls.getBackEndUrl(), this.getSessionCookie());
        OMElement synapseConfig = AXIOMUtil.stringToOM((String)synapseConfigAdminClient.getConfiguration());
        synapseConfig.getFirstChildWithName(new QName(synapseConfig.getNamespace().getNamespaceURI(), "registry")).detach();
        synapseConfig.addChild((OMNode)this.esbUtils.loadResource(resourcePath).getFirstElement());
        synapseConfigAdminClient.updateConfiguration(synapseConfig);
        this.esbUtils.verifySynapseDeployment(synapseConfig, this.contextUrls.getBackEndUrl(), this.getSessionCookie());
        Thread.sleep(3000L);
    }

    protected boolean isRunningOnStratos() throws XPathExpressionException {
        return this.context.getConfigurationValue("//executionEnvironment").equals("platform");
    }

    protected String getESBResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "ESB";
    }

    protected String getBackEndServiceUrl(String serviceName) throws XPathExpressionException {
        return EndpointGenerator.getBackEndServiceEndpointUrl(serviceName);
    }

    protected void uploadCapp(String appname, DataHandler dataHandler) throws RemoteException {
        CarbonAppUploaderClient carbonAppUploaderClient = new CarbonAppUploaderClient(this.contextUrls.getBackEndUrl(), this.sessionCookie);
        carbonAppUploaderClient.uploadCarbonAppArtifact(appname, dataHandler);
    }

    protected SynapseApplicationMetadata getSynapseAppData(String appName) throws RemoteException, ExceptionException {
        SynapseApplicationAdminClient synapseApplicationAdminClient = new SynapseApplicationAdminClient(this.contextUrls.getBackEndUrl(), this.sessionCookie);
        return synapseApplicationAdminClient.getSynapseAppData(appName);
    }

    protected OMElement setEndpoints(OMElement synapseConfig) throws XMLStreamException, XPathExpressionException {
        if (this.isBuilderEnabled()) {
            return synapseConfig;
        }
        String config = this.replaceEndpoints(synapseConfig.toString());
        return AXIOMUtil.stringToOM((String)config);
    }

    protected DataHandler setEndpoints(DataHandler dataHandler) throws XMLStreamException, IOException, XPathExpressionException {
        if (this.isBuilderEnabled()) {
            return dataHandler;
        }
        String config = this.readInputStreamAsString(dataHandler.getInputStream());
        config = this.replaceEndpoints(config);
        ByteArrayDataSource dbs = new ByteArrayDataSource(config.getBytes());
        return new DataHandler((DataSource)dbs);
    }

    private boolean isBuilderEnabled() throws XPathExpressionException {
        return this.context.getConfigurationValue("//executionEnvironment").equals("standalone");
    }

    private boolean isClusterEnabled() throws XPathExpressionException {
        return this.context.getProductGroup().isClusterEnabled();
    }

    private String getExecutionEnvironment() throws XPathExpressionException {
        return this.context.getConfigurationValue("//executionEnvironment");
    }

    private boolean isProxyWSDlExist(String serviceUrl, long synchronizingDelay) throws Exception {
        new ServiceDeploymentUtil();
        return ServiceDeploymentUtil.isServiceWSDlExist(serviceUrl, synchronizingDelay);
    }

    private boolean isProxyWSDlNotExist(String serviceUrl, long synchronizingDelay) throws Exception {
        new ServiceDeploymentUtil();
        return ServiceDeploymentUtil.isServiceWSDlNotExist(serviceUrl, synchronizingDelay);
    }

    private String replaceEndpoints(String config) throws XPathExpressionException {
        String serviceUrl = new AutomationContext("AS", TestUserMode.SUPER_TENANT_ADMIN).getContextUrls().getServiceUrl();
        config = config.replace("http://localhost:9000/services/", serviceUrl);
        config = config.replace("http://127.0.0.1:9000/services/", serviceUrl);
        return config;
    }

    protected OMElement replaceEndpoints(String relativePathToConfigFile, String serviceName, String port) throws XMLStreamException, FileNotFoundException, XPathExpressionException {
        String config = this.esbUtils.loadResource(relativePathToConfigFile).toString();
        config = config.replace("http://localhost:" + port + "/services/" + serviceName, this.getBackEndServiceUrl(serviceName));
        return AXIOMUtil.stringToOM((String)config);
    }

    private String readInputStreamAsString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    protected String login(AutomationContext context) throws IOException, XPathExpressionException, URISyntaxException, SAXException, XMLStreamException, LoginAuthenticationExceptionException, AutomationUtilException {
        LoginLogoutClient loginLogoutClient = new LoginLogoutClient(context);
        return loginLogoutClient.login();
    }

    protected String getSessionCookie() {
        return this.sessionCookie;
    }

    protected String[] getUserRole() {
        return new String[]{"admin"};
    }

    protected void reloadSessionCookie() throws Exception {
        this.context = new AutomationContext("ESB", TestUserMode.SUPER_TENANT_ADMIN);
        this.sessionCookie = this.login(this.context);
    }
}

