/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpServerRunner {
    private final SftpServer sftpServer;

    public SftpServerRunner(int port, String ftpFolderPath, String userName, String password) {
        this.sftpServer = new SftpServer(port, ftpFolderPath, userName, password);
    }

    public void start() {
        Thread thread = new Thread(this.sftpServer);
        thread.start();
    }

    public void stop() {
        this.sftpServer.stop();
    }

    private class SftpServer
    implements Runnable {
        private final Logger LOGGER = LoggerFactory.getLogger(SftpServer.class);
        private final SshServer sshd = SshServer.setUpDefaultServer();
        private final int port;
        private final String path;
        private final String ftpUser;
        private final String ftpPassword;

        SftpServer(int port, String path, String ftpUser, String ftpPassword) {
            this.port = port;
            this.path = path;
            this.ftpUser = ftpUser;
            this.ftpPassword = ftpPassword;
        }

        @Override
        public void run() {
            this.sshd.setPort(this.port);
            this.sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystem.Factory()));
            this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
            this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
            this.sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.path));
            this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

                public boolean authenticate(String username, String password, ServerSession session) {
                    return StringUtils.equals((CharSequence)username, (CharSequence)SftpServer.this.ftpUser) && StringUtils.equals((CharSequence)password, (CharSequence)SftpServer.this.ftpPassword);
                }
            });
            try {
                this.LOGGER.info("Starting SFTP server on port {}", (Object)this.port);
                this.sshd.start();
            }
            catch (IOException e) {
                this.LOGGER.error("Error starting SFTP server", (Throwable)e);
            }
        }

        private void stop() {
            try {
                this.sshd.stop();
            }
            catch (InterruptedException e) {
                this.LOGGER.error("Error stopping SFTP server", (Throwable)e);
            }
        }
    }
}

