/*
 * Decompiled with CFR 0.152.
 */
package samples.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap {
    private static final String JAR_CLASS_PATHS = "jar.class.paths";
    private static final String SYSTEM_HOME = "system.home";

    public static void main(String[] args) {
        if (System.getProperty(JAR_CLASS_PATHS) != null) {
            String root = System.getProperty(SYSTEM_HOME, ".");
            String classpaths = System.getProperty(JAR_CLASS_PATHS);
            String[] paths = classpaths.split(",");
            ArrayList<URL> classpath = new ArrayList<URL>();
            if (paths == null || root == null) {
                System.out.println("system.home and jar.class.paths system properties should be set");
                System.exit(1);
            }
            try {
                for (String path : paths) {
                    String jarRoot;
                    File file;
                    String path_new;
                    String prefix;
                    int index = path.lastIndexOf("../");
                    if (index > 0) {
                        prefix = path.substring(0, index + 3);
                        path_new = path.substring(index + 3, path.length());
                    } else {
                        prefix = "";
                        path_new = path;
                    }
                    String[] folders = path_new.split("/");
                    String suffix = "";
                    for (String folder : folders) {
                        String suffix_new = folder + File.separator;
                        suffix = suffix + suffix_new;
                    }
                    int fileSepLastIndex = suffix.lastIndexOf(File.separator);
                    String suffix_without_fileseperator = suffix.substring(0, fileSepLastIndex);
                    if ("".equals(prefix)) {
                        file = new File(root + File.separator + suffix);
                        jarRoot = root + File.separator + suffix_without_fileseperator;
                    } else {
                        file = new File(root + File.separator + prefix + File.separator + suffix);
                        jarRoot = root + File.separator + prefix + File.separator + suffix_without_fileseperator;
                    }
                    classpath.add(file.toURI().toURL());
                    Bootstrap.addJarFileUrls(classpath, new File(jarRoot));
                }
                URLClassLoader classLoader = new URLClassLoader(classpath.toArray(new URL[classpath.size()]), null);
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> appClass = classLoader.loadClass("samples.util.SampleAxis2Server");
                Object app = appClass.newInstance();
                Method m = app.getClass().getMethod("startServer", String[].class);
                m.invoke(app, new Object[]{args});
            }
            catch (Exception e) {
                System.out.println("Server could not start due to class loading issue " + e);
                System.exit(1);
            }
        }
    }

    private static void addJarFileUrls(List<URL> jarUrls, File root) throws MalformedURLException {
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isDirectory() && child.canRead()) {
                Bootstrap.addJarFileUrls(jarUrls, child);
                continue;
            }
            if (!child.isFile() || !child.canRead() || !child.getName().toLowerCase().endsWith(".jar")) continue;
            jarUrls.add(child.toURI().toURL());
        }
    }
}

