/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.tests.server.mgt;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NamingException;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.metrics.common.MetricsConfigException;
import org.wso2.carbon.metrics.data.common.Metric;
import org.wso2.carbon.metrics.data.common.MetricAttribute;
import org.wso2.carbon.metrics.data.common.MetricList;
import org.wso2.carbon.metrics.data.common.MetricType;
import org.wso2.carbon.metrics.impl.MetricsLevelConfigException;
import org.wso2.carbon.metrics.manager.jmx.MetricManagerMXBean;
import org.wso2.carbon.metrics.view.ui.MetricDataWrapper;
import org.wso2.carbon.metrics.view.ui.MetricsViewClient;
import org.wso2.mb.integration.common.clients.AndesClient;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSClientConfiguration;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSConsumerClientConfiguration;
import org.wso2.mb.integration.common.clients.configurations.AndesJMSPublisherClientConfiguration;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientConfigurationException;
import org.wso2.mb.integration.common.clients.exceptions.AndesClientException;
import org.wso2.mb.integration.common.clients.operations.utils.ExchangeType;
import org.wso2.mb.integration.common.utils.backend.MBIntegrationBaseTest;

public class MetricsTestCase
extends MBIntegrationBaseTest {
    private String sessionCookie;

    @BeforeClass(alwaysRun=true)
    public void init() throws XPathExpressionException, MalformedURLException, AutomationUtilException, MetricsConfigException, MetricsLevelConfigException, RemoteException, LoginAuthenticationExceptionException {
        super.init(TestUserMode.SUPER_TENANT_USER);
        LoginLogoutClient loginLogoutClientForAdmin = new LoginLogoutClient(this.automationContext);
        this.sessionCookie = loginLogoutClientForAdmin.login();
    }

    @Test(groups={"wso2.mb"}, description="Queue subscribers count metric test case")
    public void performQueueSubscriberCountTestCase() throws AndesClientConfigurationException, JMSException, NamingException, IOException, AndesClientException, InterruptedException, AutomationUtilException, XPathExpressionException, MalformedObjectNameException {
        long msgCount = 1000L;
        int subscriberCount = 5;
        AndesJMSConsumerClientConfiguration consumerConfig = new AndesJMSConsumerClientConfiguration(this.getAMQPPort().intValue(), ExchangeType.QUEUE, "singleQueue");
        consumerConfig.setMaximumMessagesToReceived(msgCount * 2L);
        consumerConfig.setPrintsPerMessageCount(msgCount / 10L);
        AndesJMSPublisherClientConfiguration publisherConfig = new AndesJMSPublisherClientConfiguration(this.getAMQPPort().intValue(), ExchangeType.QUEUE, "singleQueue");
        publisherConfig.setNumberOfMessagesToSend(msgCount);
        publisherConfig.setPrintsPerMessageCount(msgCount / 10L);
        AndesClient consumerClient = null;
        for (int i = 0; i < subscriberCount; ++i) {
            consumerClient = new AndesClient((AndesJMSClientConfiguration)consumerConfig, true);
            consumerClient.startClient();
        }
        AndesClient publisherClient = new AndesClient((AndesJMSClientConfiguration)publisherConfig, true);
        publisherClient.startClient();
        Thread.sleep(5000L);
        long fromTime = System.currentTimeMillis();
        this.invokeJMXReportOperation();
        MetricList metricList = new MetricList();
        MetricsViewClient metricsViewClient = new MetricsViewClient(this.sessionCookie, this.backendURL, null);
        String source = metricsViewClient.getAllSources()[0];
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        metrics.add(new Metric(MetricType.GAUGE, "org.wso2.mb.queue.subscribers.count", "Total Queue Subscribers", MetricAttribute.VALUE, null));
        metricList.setMetric(metrics.toArray(new Metric[metrics.size()]));
        MetricDataWrapper metricData = metricsViewClient.findLastMetrics(metricList, source, String.valueOf(fromTime));
        consumerClient.stopClient();
        publisherClient.stopClient();
        Assert.assertEquals((int)metricData.getData()[0][1].intValue(), (int)subscriberCount, (String)(metricData.getData()[0][1].intValue() + " subscribers found."));
    }

    @Test(groups={"wso2.mb"}, description="Topic subscribers count metric test case")
    public void performTopicSubscriberCountTestCase() throws AndesClientConfigurationException, JMSException, NamingException, IOException, AndesClientException, InterruptedException, AutomationUtilException, XPathExpressionException, MalformedObjectNameException {
        long msgCount = 1000L;
        int subscriberCount = 5;
        AndesJMSConsumerClientConfiguration consumerConfig = new AndesJMSConsumerClientConfiguration(this.getAMQPPort().intValue(), ExchangeType.TOPIC, "singleTopic");
        consumerConfig.setMaximumMessagesToReceived(msgCount * 2L);
        consumerConfig.setPrintsPerMessageCount(msgCount / 10L);
        AndesJMSPublisherClientConfiguration publisherConfig = new AndesJMSPublisherClientConfiguration(this.getAMQPPort().intValue(), ExchangeType.TOPIC, "singleTopic");
        publisherConfig.setNumberOfMessagesToSend(msgCount);
        publisherConfig.setPrintsPerMessageCount(msgCount / 10L);
        AndesClient consumerClient = null;
        for (int i = 0; i < subscriberCount; ++i) {
            consumerClient = new AndesClient((AndesJMSClientConfiguration)consumerConfig, true);
            consumerClient.startClient();
        }
        AndesClient publisherClient = new AndesClient((AndesJMSClientConfiguration)publisherConfig, true);
        publisherClient.startClient();
        Thread.sleep(5000L);
        long fromTime = System.currentTimeMillis();
        this.invokeJMXReportOperation();
        MetricList metricList = new MetricList();
        MetricsViewClient metricsViewClient = new MetricsViewClient(this.sessionCookie, this.backendURL, null);
        String source = metricsViewClient.getAllSources()[0];
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        metrics.add(new Metric(MetricType.GAUGE, "org.wso2.mb.topic.subscribers.count", "Total Topic Subscribers", MetricAttribute.VALUE, null));
        metricList.setMetric(metrics.toArray(new Metric[metrics.size()]));
        MetricDataWrapper metricData = metricsViewClient.findLastMetrics(metricList, source, String.valueOf(fromTime));
        consumerClient.stopClient();
        publisherClient.stopClient();
        Assert.assertEquals((int)metricData.getData()[0][1].intValue(), (int)subscriberCount, (String)(metricData.getData()[0][1].intValue() + " subscribers found."));
    }

    @Test(groups={"wso2.mb"}, description="Metrics report test case")
    public void performMetricsReportTestCase() throws AndesClientConfigurationException, JMSException, NamingException, IOException, AndesClientException, InterruptedException, MalformedObjectNameException, XPathExpressionException {
        long msgCount = 1000L;
        AndesJMSConsumerClientConfiguration consumerConfig = new AndesJMSConsumerClientConfiguration(this.getAMQPPort().intValue(), ExchangeType.QUEUE, "singleQueue");
        consumerConfig.setMaximumMessagesToReceived(msgCount * 2L);
        consumerConfig.setPrintsPerMessageCount(msgCount / 10L);
        AndesJMSPublisherClientConfiguration publisherConfig = new AndesJMSPublisherClientConfiguration(this.getAMQPPort().intValue(), ExchangeType.QUEUE, "singleQueue");
        publisherConfig.setNumberOfMessagesToSend(msgCount);
        publisherConfig.setPrintsPerMessageCount(msgCount / 10L);
        AndesClient consumerClient = new AndesClient((AndesJMSClientConfiguration)consumerConfig, true);
        consumerClient.startClient();
        AndesClient publisherClient = new AndesClient((AndesJMSClientConfiguration)publisherConfig, true);
        publisherClient.startClient();
        Thread.sleep(5000L);
        long fromTime = System.currentTimeMillis();
        this.invokeJMXReportOperation();
        MetricList metricList = new MetricList();
        MetricsViewClient metricsViewClient = new MetricsViewClient(this.sessionCookie, this.backendURL, null);
        String source = metricsViewClient.getAllSources()[0];
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        metrics.add(new Metric(MetricType.GAUGE, "org.wso2.mb.inbound.disruptor.message.count", "Total Messages in Inbound Disruptor", MetricAttribute.VALUE, null));
        metrics.add(new Metric(MetricType.GAUGE, "org.wso2.mb.inbound.disruptor.ack.count", "Total Acks in Inbound Disruptor", MetricAttribute.VALUE, null));
        metrics.add(new Metric(MetricType.GAUGE, "org.wso2.mb.outbound.disruptor.message.count", "Total Messages in Outbound Disruptor", MetricAttribute.VALUE, null));
        metrics.add(new Metric(MetricType.GAUGE, "org.wso2.mb.queue.subscribers.count", "Total Queue Subscribers", MetricAttribute.VALUE, null));
        metrics.add(new Metric(MetricType.GAUGE, "org.wso2.mb.channels.active.count", "Total Channels", MetricAttribute.VALUE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.receive", "Received Messages Mean Rate", MetricAttribute.MEAN_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.receive", "Received Messages Last Minute Rate", MetricAttribute.M1_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.receive", "Received Messages Last 5 Minutes Rate", MetricAttribute.M5_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.receive", "Received Messages Last 15 Minutes Rate", MetricAttribute.M15_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.receive", "Received Acknowledgements Mean Rate", MetricAttribute.MEAN_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.receive", "Received Acknowledgements Last Minute Rate", MetricAttribute.M1_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.receive", "Received Acknowledgements Last 5 Minutes Rate", MetricAttribute.M5_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.receive", "Received Acknowledgements Last 15 Minutes Rate", MetricAttribute.M15_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.sent", "Sent Messages Mean Rate", MetricAttribute.MEAN_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.sent", "Sent Messages Last Minute Rate", MetricAttribute.M1_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.sent", "Sent Messages Last 5 Minutes Rate", MetricAttribute.M5_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.message.sent", "Sent Messages Last 15 Minutes Rate", MetricAttribute.M15_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.sent", "Sent Acknowledgements Mean Rate", MetricAttribute.M1_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.sent", "Sent Acknowledgements Last Minute Rate", MetricAttribute.M1_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.sent", "Sent Acknowledgements Last 5 Minutes Rate", MetricAttribute.M5_RATE, null));
        metrics.add(new Metric(MetricType.METER, "org.wso2.mb.ack.sent", "Sent Acknowledgements Last 15 Minutes Rate", MetricAttribute.M15_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Minimum", MetricAttribute.MIN, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Mean", MetricAttribute.MEAN, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Maximum", MetricAttribute.MAX, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Standard Deviation", MetricAttribute.STDDEV, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", " 50th Percentile", MetricAttribute.P50, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", " 75th Percentile", MetricAttribute.P75, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "95th Percentile", MetricAttribute.P95, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "98th Percentile", MetricAttribute.P98, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "99th Percentile", MetricAttribute.P99, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "999th Percentile", MetricAttribute.P999, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Mean Rate", MetricAttribute.MEAN_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Last Minute Rate", MetricAttribute.M1_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Last 5 Minutes Rate", MetricAttribute.M5_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.read", "Last 15 Minutes Rate", MetricAttribute.M15_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Minimum", MetricAttribute.MIN, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Mean", MetricAttribute.MEAN, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Maximum", MetricAttribute.MAX, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Standard Deviation", MetricAttribute.STDDEV, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "50th Percentile", MetricAttribute.P50, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "75th Percentile", MetricAttribute.P75, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "95th Percentile", MetricAttribute.P95, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "98th Percentile", MetricAttribute.P98, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "99th Percentile", MetricAttribute.P99, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "999th Percentile", MetricAttribute.P999, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Mean Rate", MetricAttribute.MEAN_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Last Minute Rate", MetricAttribute.M1_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Last 5 Minutes Rate", MetricAttribute.M5_RATE, null));
        metrics.add(new Metric(MetricType.TIMER, "org.wso2.mb.database.write", "Last 15 Minutes Rate", MetricAttribute.M15_RATE, null));
        metricList.setMetric(metrics.toArray(new Metric[metrics.size()]));
        MetricDataWrapper metricData = metricsViewClient.findLastMetrics(metricList, source, String.valueOf(fromTime));
        consumerClient.stopClient();
        publisherClient.stopClient();
        for (int i = 0; i < metricData.getMetadata().getNames().length; ++i) {
            BigDecimal value = metricData.getData()[0][i];
            Assert.assertTrue((null != value ? 1 : 0) != 0, (String)("Metric [" + metricData.getMetadata().getNames()[i] + "] value was not reported."));
        }
    }

    private void invokeJMXReportOperation() throws IOException, MalformedObjectNameException, XPathExpressionException {
        int JMXServicePort = this.getJMXServerPort();
        int RMIRegistryPort = this.getRMIRegistryPort();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost:" + JMXServicePort + "/jndi/rmi://localhost:" + RMIRegistryPort + "/jmxrmi");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] credentials = new String[]{"admin", "admin"};
        env.put("jmx.remote.credentials", credentials);
        JMXConnector jmxConnector = JMXConnectorFactory.connect(url, env);
        MBeanServerConnection mbeanServerConnection = jmxConnector.getMBeanServerConnection();
        ObjectName mbeanName = new ObjectName("org.wso2.carbon:type=MetricManager");
        MetricManagerMXBean mbeanProxy = MBeanServerInvocationHandler.newProxyInstance(mbeanServerConnection, mbeanName, MetricManagerMXBean.class, true);
        mbeanProxy.report();
        jmxConnector.close();
    }
}

