/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mb.integration.tests.server.mgt;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.carbonserver.MultipleServersManager;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;
import org.wso2.mb.integration.tests.server.mgt.CarbonTestServerManager;
import org.wso2.mb.integration.tests.server.mgt.LoginLogoutClient;

public class NewInstanceTestCase {
    private static final Log log = LogFactory.getLog(NewInstanceTestCase.class);
    private MultipleServersManager manager = new MultipleServersManager();
    private Map<String, String> startupParameterMap1 = new HashMap<String, String>();
    private long TIMEOUT = 180000L;

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
    @BeforeClass(groups={"mb.server.startup"})
    public void testStartServers() throws XPathExpressionException, AutomationFrameworkException {
        AutomationContext context = new AutomationContext();
        this.startupParameterMap1.put("-DportOffset", "2");
        CarbonTestServerManager server1 = new CarbonTestServerManager(context, System.getProperty("carbon.zip"), this.startupParameterMap1);
        this.manager.startServers(new TestServerManager[]{server1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
    @Test(groups={"mb.server.startup"})
    public void waitForPortTestCase() {
        boolean isPortOpen = false;
        long startTime = System.currentTimeMillis();
        String hostName = "localhost";
        while (!isPortOpen && System.currentTimeMillis() - startTime < this.TIMEOUT) {
            Socket socket = null;
            try {
                InetAddress address = InetAddress.getByName(hostName);
                socket = new Socket(address, 9445);
                isPortOpen = socket.isConnected();
            }
            catch (IOException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (socket == null || !socket.isConnected()) continue;
                    socket.close();
                }
                catch (IOException e) {
                    log.error((Object)"Cannot close the socket which is used to check the server status ", (Throwable)e);
                }
            }
        }
        Assert.assertTrue((boolean)isPortOpen);
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
    @Test(groups={"mb.server.startup"})
    public void waitForLoginTestCase() {
        long startTime = System.currentTimeMillis();
        boolean loginFailed = true;
        while (System.currentTimeMillis() - startTime < this.TIMEOUT && loginFailed) {
            log.info((Object)"Waiting to login user...");
            try {
                LoginLogoutClient loginClient = new LoginLogoutClient("https://localhost:9445/services/", "admin", "admin");
                loginClient.login();
                loginFailed = false;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.info((Object)"Login failed after server startup", (Throwable)e);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Assert.assertFalse((boolean)loginFailed);
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
    @AfterClass
    public void clean() throws AutomationFrameworkException {
        this.manager.stopAllServers();
    }
}

