/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.services.jaxrs.coffeesample;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.wso2.esb.integration.services.jaxrs.coffeesample.StarbucksOutletService;
import org.wso2.esb.integration.services.jaxrs.coffeesample.bean.Order;
import org.wso2.esb.integration.services.jaxrs.coffeesample.bean.Payment;
import org.wso2.esb.integration.services.jaxrs.coffeesample.bean.PaymentStatus;

public class StarbucksOutletServiceImpl
implements StarbucksOutletService {
    private Map<String, Order> ordersList = new ConcurrentHashMap<String, Order>();
    private Map<String, Payment> paymentRegister = new ConcurrentHashMap<String, Payment>();
    private final Map<String, Double> priceList = new ConcurrentHashMap<String, Double>();
    private static final Random rand = new Random();

    public StarbucksOutletServiceImpl() {
        this.init();
    }

    @Override
    public Response addOrder(Order orderBean) {
        String drinkName = orderBean.getDrinkName();
        String additions = orderBean.getAdditions();
        orderBean.setCost(this.calculateCost(drinkName, additions));
        this.ordersList.put(orderBean.getOrderId(), orderBean);
        return Response.ok().entity((Object)orderBean).type("application/json").build();
    }

    @Override
    public Order getOrder(String id) {
        return this.ordersList.get(id);
    }

    @Override
    public Response updateOrder(Order orderBean) {
        String orderId = orderBean.getOrderId();
        String drinkName = orderBean.getDrinkName();
        String additions = orderBean.getAdditions();
        Order order = this.ordersList.get(orderId);
        if (order != null) {
            if (order.isLocked()) {
                return Response.notModified().type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            if (drinkName != null && !"".equals(drinkName)) {
                order.setDrinkName(drinkName);
            } else {
                drinkName = order.getDrinkName();
            }
            order.setAdditions(additions);
            order.setCost(this.calculateCost(drinkName, additions));
            return Response.ok((Object)order).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return null;
    }

    @Override
    public Response getPendingOrders() {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Order order : this.ordersList.values()) {
            if (order.isLocked()) continue;
            orders.add(order);
        }
        return Response.ok(orders).type("application/atom+xml;type=feed").build();
    }

    @Override
    public Response lockOrder(String id) {
        Order order = this.ordersList.get(id);
        if (order != null) {
            order.setLocked(true);
            return Response.ok((Object)order).type("application/xml").build();
        }
        return Response.notModified().entity((Object)id).type("application/xml").build();
    }

    @Override
    public Response removeOrder(String id) {
        Boolean removed = this.ordersList.remove(id) != null;
        this.paymentRegister.remove(id);
        String status = removed.toString();
        return removed != false ? Response.ok((Object)status).build() : Response.notModified().build();
    }

    @Override
    public Response doPayment(String id, Payment payment) {
        String name = payment.getName();
        Double amount = payment.getAmount();
        String cardNumber = payment.getCardNumber();
        String expiryDate = payment.getExpiryDate();
        Payment registeredPayment = this.paymentRegister.get(id);
        if (registeredPayment != null) {
            PaymentStatus paymentStatus = new PaymentStatus("Duplicate Payment", registeredPayment);
            return Response.notModified().entity((Object)paymentStatus).type("application/json").build();
        }
        Order order = this.ordersList.get(id);
        if (order == null) {
            PaymentStatus paymentStatus = new PaymentStatus("Invalid Order ID", null);
            return Response.notModified().entity((Object)paymentStatus).type("application/json").build();
        }
        if (!order.isAmountAcceptable(amount)) {
            PaymentStatus paymentStatus = new PaymentStatus("Insufficient Funds", null);
            return Response.notModified().entity((Object)paymentStatus).type("application/json").build();
        }
        registeredPayment = new Payment(id);
        registeredPayment.setAmount(amount);
        registeredPayment.setCardNumber(cardNumber);
        registeredPayment.setExpiryDate(expiryDate);
        registeredPayment.setName(name);
        this.paymentRegister.put(id, registeredPayment);
        PaymentStatus paymentStatus = new PaymentStatus("Payment Accepted", registeredPayment);
        return Response.ok().entity((Object)paymentStatus).type("application/json").build();
    }

    @Override
    public Payment getPayment(String id) {
        return this.paymentRegister.get(id);
    }

    private double calculateCost(String drinkName, String additions) {
        double cost = this.getPrice(drinkName, false);
        if (additions != null && !"".equals(additions)) {
            String[] additionalItems;
            for (String item : additionalItems = additions.split(" ")) {
                cost += this.getPrice(item, true);
            }
        }
        return Double.parseDouble(Order.currencyFormat.format(cost));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getPrice(String item, boolean addition) {
        Map<String, Double> map = this.priceList;
        synchronized (map) {
            Double price = this.priceList.get(item);
            if (price == null) {
                price = addition ? Double.valueOf(rand.nextDouble() * 5.0) : Double.valueOf((double)(rand.nextInt(8) + 2) - 0.01);
                this.priceList.put(item, price);
            }
            return price;
        }
    }

    private void init() {
        String drinkName = "Vanilla Flavored Coffee";
        String additions = "Milk";
        Order order = new Order();
        order.setOrderId("123");
        order.setDrinkName(drinkName);
        order.setAdditions(additions);
        order.setCost(this.calculateCost(drinkName, additions));
        this.ordersList.put(order.getOrderId(), order);
        drinkName = "Chocolate Flavored Coffee";
        order = new Order();
        order.setOrderId("444");
        order.setDrinkName(drinkName);
        order.setCost(this.calculateCost(drinkName, null));
        this.ordersList.put(order.getOrderId(), order);
    }
}

