/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.es.ui.integration.extension.test.publisher;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;
import org.wso2.es.integration.common.clients.ResourceAdminServiceClient;
import org.wso2.es.ui.integration.util.BaseUITestCase;
import org.wso2.es.ui.integration.util.ESUtil;
import org.wso2.es.ui.integration.util.ESWebDriver;

public class ESPublisherAssetOverrideRendererTestCase
extends BaseUITestCase {
    private static final String ASSET_NAME = "Servicex 2";
    private static final String VERSION = "1.0.0";
    private static final String SCOPES = "test";
    private static final String TYPES = "new";
    private static final int MAX_POLL_COUNT = 30;
    private String lifecycleUrl = null;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws Exception {
        super.init();
        this.driver = new ESWebDriver(BrowserManager.getWebDriver());
        this.baseUrl = this.getWebAppURL();
        ESUtil.login((ESWebDriver)this.driver, (String)this.baseUrl, (String)"publisher", (String)this.userInfo.getUserName(), (String)this.userInfo.getPassword());
        this.resourcePath = "/_system/governance/servicesx/" + this.currentUserName + "/" + ASSET_NAME + "/" + VERSION;
        AutomationContext automationContext = new AutomationContext("ES", TestUserMode.SUPER_TENANT_ADMIN);
        this.adminUserName = automationContext.getSuperTenant().getTenantAdmin().getUserName();
        this.adminUserPwd = automationContext.getSuperTenant().getTenantAdmin().getPassword();
        this.backendURL = automationContext.getContextUrls().getBackEndUrl();
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.backendURL, this.adminUserName, this.adminUserPwd);
        this.driver.get(this.baseUrl + "/publisher/assets/servicex/list");
        this.driver.findElement(By.id((String)"Addservicex")).click();
        this.driver.findElement(By.name((String)"overview_name")).clear();
        this.driver.findElement(By.name((String)"overview_name")).sendKeys(new CharSequence[]{ASSET_NAME});
        this.driver.findElement(By.name((String)"overview_version")).clear();
        this.driver.findElement(By.name((String)"overview_version")).sendKeys(new CharSequence[]{VERSION});
        this.driver.findElement(By.name((String)"overview_scopes")).clear();
        this.driver.findElement(By.name((String)"overview_scopes")).sendKeys(new CharSequence[]{SCOPES});
        this.driver.findElement(By.name((String)"overview_types")).clear();
        this.driver.findElement(By.name((String)"overview_types")).sendKeys(new CharSequence[]{TYPES});
        Assert.assertTrue((boolean)ESPublisherAssetOverrideRendererTestCase.isElementPresent((WebDriver)this.driver, (By)By.name((String)"images_thumbnail")));
        this.driver.findElement(By.name((String)"images_thumbnail")).sendKeys(new CharSequence[]{FrameworkPathUtil.getReportLocation() + "/../src/test/resources/images/thumbnail.jpg"});
        this.driver.findElement(By.id((String)"btn-create-asset")).click();
        this.driver.findElementPoll(By.linkText((String)ASSET_NAME), 30);
        this.driver.findElement(By.linkText((String)ASSET_NAME)).click();
        this.lifecycleUrl = this.driver.getCurrentUrl().replace("details", "lifecycle");
    }

    @Test(groups={"wso2.es.extensions"}, description="Test overriding a renderer in extensions")
    public void testESPublisherAssetOverrideRendererTestCase() throws Exception {
        this.driver.get(this.lifecycleUrl);
        Assert.assertTrue((boolean)ESPublisherAssetOverrideRendererTestCase.isElementPresent((WebDriver)this.driver, (By)By.id((String)"assetLifecyclePartial")));
        Assert.assertEquals((String)this.driver.findElement(By.id((String)"assetLifecyclePartial")).getText(), (String)"Asset Overridden Lifecycle through renderer");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.driver.get(this.baseUrl + "/publisher/logout");
        this.resourceAdminServiceClient.deleteResource(this.resourcePath);
        this.driver.quit();
    }
}

