/*
 * Decompiled with CFR 0.152.
 */
package eventing.samples.broker;

import eventing.samples.broker.PersistentBroker;
import org.wso2.eventing.Event;
import org.wso2.eventing.EventSink;
import org.wso2.eventing.exceptions.EventException;
import org.wso2.eventing.impl.ConsoleSink;

public class BrokerToy {
    public static void main(String[] args) throws Exception {
        ConsoleSink normal = new ConsoleSink("Good");
        BrokenSink bad = new BrokenSink("Bad");
        PersistentBroker broker = new PersistentBroker();
        broker.subscribe((EventSink)normal, null);
        broker.subscribe((EventSink)bad, null);
        int i = 0;
        while (true) {
            broker.onEvent(new Event("Event " + i++));
            Thread.sleep(1000L);
        }
    }

    public static class BrokenSink
    extends ConsoleSink {
        public BrokenSink(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(Event event) throws EventException {
            BrokenSink brokenSink = this;
            synchronized (brokenSink) {
                if (Math.random() < 0.33) {
                    String message = this.getName() + " failed delivery (" + event.getMessage() + ")!";
                    PersistentBroker.print(message);
                    throw new EventException(message);
                }
            }
            super.onEvent(event);
        }
    }
}

