/*
 * Decompiled with CFR 0.152.
 */
package eventing.samples.broker;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.wso2.eventing.Event;
import org.wso2.eventing.EventSink;
import org.wso2.eventing.impl.Broker;

public class PersistentBroker
extends Broker {
    Postman postman = new Postman(5000L);
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String message) {
        Object object = lock;
        synchronized (object) {
            System.out.print(DateFormat.getTimeInstance(1).format(new Date()));
            System.out.println(" " + message);
        }
    }

    public void onEvent(Event event) {
        ArrayList deliveryList = new ArrayList(this.subscribers);
        int i = 0;
        while (i < deliveryList.size()) {
            EventSink sink = (EventSink)deliveryList.get(i);
            try {
                sink.onEvent(event);
            }
            catch (Exception e) {
                DeliveryOrder order = new DeliveryOrder(sink, event);
                this.postman.submitOrder(order);
                ++i;
                continue;
            }
            deliveryList.remove(i);
        }
    }

    class Postman
    implements Runnable {
        boolean running;
        long periodicity;
        ArrayList pendingOrders = new ArrayList();

        public Postman(long periodicity) {
            this.periodicity = periodicity;
        }

        public synchronized void submitOrder(DeliveryOrder order) {
            if (!this.running) {
                this.running = true;
                new Thread(this).start();
            }
            this.pendingOrders.add(order);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                Object order;
                int i = 0;
                while (i < this.pendingOrders.size()) {
                    order = (DeliveryOrder)this.pendingOrders.get(i);
                    try {
                        if (((DeliveryOrder)order).deliver()) {
                            this.pendingOrders.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        this.pendingOrders.remove(i);
                    }
                }
                try {
                    order = this;
                    synchronized (order) {
                        if (this.pendingOrders.isEmpty()) {
                            this.wait();
                        }
                    }
                    Thread.sleep(this.periodicity);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class DeliveryOrder {
        EventSink sink;
        Event event;
        long creationTime;
        long timeToLive = 30000L;

        public DeliveryOrder(EventSink sink, Event event) {
            this.sink = sink;
            this.event = event;
            this.creationTime = new Date().getTime();
        }

        public boolean deliver() throws Exception {
            PersistentBroker.print("Trying to redeliver '" + this.event.getMessage() + "'");
            try {
                this.sink.onEvent(this.event);
            }
            catch (Exception e) {
                if (new Date().getTime() > this.creationTime + this.timeToLive) {
                    throw new Exception("TIMED OUT: " + this.event.getMessage());
                }
                return false;
            }
            return true;
        }
    }
}

