/*
 * Decompiled with CFR 0.152.
 */
package eventing.samples.filter;

import eventing.samples.filter.ColorFilteringSink;
import eventing.samples.filter.ColoredEvent;
import org.wso2.eventing.Event;
import org.wso2.eventing.EventFilter;
import org.wso2.eventing.EventSink;
import org.wso2.eventing.FilteredSink;
import org.wso2.eventing.impl.BasicSource;
import org.wso2.eventing.impl.ConsoleSink;

public class ColorToy {
    public static void main(String[] args) throws Exception {
        ColorFilteringSink boy = new ColorFilteringSink("blue", (EventSink)new ConsoleSink("Boy"));
        FilteredSink girl = new FilteredSink(new EventFilter(){

            public boolean match(Event event) {
                try {
                    return "pink".equals(((ColoredEvent)event).getColor());
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, (EventSink)new ConsoleSink("Girl"));
        ColorGenerator gen = new ColorGenerator();
        Thread thread = new Thread(gen);
        thread.start();
        gen.subscribe((EventSink)boy, null);
        gen.subscribe((EventSink)girl, null);
    }

    static class ColorGenerator
    extends BasicSource
    implements Runnable {
        private boolean done;
        private String[] colors = new String[]{"red", "pink", "blue", "green"};

        ColorGenerator() {
        }

        public void stop() {
            this.done = true;
        }

        public void run() {
            try {
                int i = 0;
                while (!this.done) {
                    Thread.sleep(1000L);
                    String color = this.colors[i % this.colors.length];
                    ColoredEvent e = new ColoredEvent(color);
                    e.setMessage("event #" + i + " (" + color + ")");
                    System.out.println("Emit - " + e.getMessage());
                    this.publish(e);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

