/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.imwrapper.core;

import org.wso2.imwrapper.core.IMException;
import org.wso2.imwrapper.core.IMWrapper;
import org.wso2.imwrapper.jabber.JabberWrapperImpl;
import org.wso2.imwrapper.msn.MSNWrapperImpl;
import org.wso2.imwrapper.oscar.OscarWrapperImpl;
import org.wso2.imwrapper.yahoo.YahooWrapperImpl;

public class IMWrapperFactory {
    public static String MSN = "msn";
    public static String AIM = "aim";
    public static String ICQ = "icq";
    public static String JABBER = "jabber";
    public static String YAHOO = "yahoo";

    public static IMWrapper createIMProtocolImpl(String protocol) throws IMException {
        if (MSN.equalsIgnoreCase(protocol)) {
            return new MSNWrapperImpl();
        }
        if (AIM.equalsIgnoreCase(protocol) || ICQ.equalsIgnoreCase(protocol)) {
            return new OscarWrapperImpl();
        }
        if (JABBER.equalsIgnoreCase(protocol)) {
            return new JabberWrapperImpl();
        }
        if (YAHOO.equalsIgnoreCase(protocol)) {
            return new YahooWrapperImpl();
        }
        throw new IMException("Unsupported protocol, Supported protocols are msn, aim, icq and jabber");
    }
}

